/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.async;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.async.AsyncShell;
import org.crsh.shell.impl.async.Status;
import org.crsh.text.Chunk;

public class AsyncProcess
implements ShellProcess {
    private final String request;
    private ShellProcessContext caller;
    private ShellProcess callee;
    private AsyncShell shell;
    private Status status;
    private final Object lock;
    private final ShellProcessContext context = new ShellProcessContext(){

        public int getWidth() {
            return AsyncProcess.this.caller.getWidth();
        }

        public int getHeight() {
            return AsyncProcess.this.caller.getHeight();
        }

        public String getProperty(String name) {
            return AsyncProcess.this.caller.getProperty(name);
        }

        public String readLine(String msg, boolean echo) {
            return AsyncProcess.this.caller.readLine(msg, echo);
        }

        public void provide(Chunk element) throws IOException {
            AsyncProcess.this.caller.provide(element);
        }

        public void flush() throws IOException {
            AsyncProcess.this.caller.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(ShellResponse response) {
            Object object = AsyncProcess.this.lock;
            synchronized (object) {
                switch (AsyncProcess.this.status) {
                    case CONSTRUCTED: 
                    case QUEUED: {
                        throw new AssertionError((Object)"Should not happen");
                    }
                    case CANCELED: {
                        response = ShellResponse.cancelled();
                        AsyncProcess.this.status = Status.TERMINATED;
                        break;
                    }
                    case EVALUATING: {
                        AsyncProcess.this.status = Status.TERMINATED;
                        break;
                    }
                    case TERMINATED: {
                        throw new IllegalStateException("Cannot end a process already terminated");
                    }
                }
            }
            AsyncProcess.this.caller.end(response);
        }
    };

    AsyncProcess(AsyncShell shell, String request) {
        this.shell = shell;
        this.request = request;
        this.callee = null;
        this.status = Status.CONSTRUCTED;
        this.lock = new Object();
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ShellProcessContext processContext) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status != Status.CONSTRUCTED) {
                throw new IllegalStateException("State was " + (Object)((Object)this.status));
            }
            this.status = Status.QUEUED;
            this.callee = this.shell.shell.createProcess(this.request);
            this.caller = processContext;
        }
        Callable<AsyncProcess> task = new Callable<AsyncProcess>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AsyncProcess call() throws Exception {
                try {
                    ShellResponse response;
                    Object object = AsyncProcess.this.lock;
                    synchronized (object) {
                        switch (AsyncProcess.this.status) {
                            case CANCELED: {
                                response = ShellResponse.cancelled();
                                break;
                            }
                            case QUEUED: {
                                AsyncProcess.this.status = Status.EVALUATING;
                                response = null;
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    if (response == null) {
                        try {
                            AsyncProcess.this.callee.execute(AsyncProcess.this.context);
                            response = ShellResponse.ok();
                        }
                        catch (Throwable t) {
                            response = ShellResponse.internalError("Unexpected throwable when executing process", t);
                        }
                    }
                    try {
                        AsyncProcess.this.context.end(response);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    object = AsyncProcess.this;
                    return object;
                }
                finally {
                    Object object = ((AsyncProcess)AsyncProcess.this).shell.lock;
                    synchronized (object) {
                        ((AsyncProcess)AsyncProcess.this).shell.processes.remove(AsyncProcess.this);
                    }
                }
            }
        };
        Object object2 = this.shell.lock;
        synchronized (object2) {
            if (!this.shell.closed) {
                this.shell.executor.submit(task);
                this.shell.processes.add(this);
            } else {
                boolean invokeEnd;
                Object object3 = this.lock;
                synchronized (object3) {
                    invokeEnd = this.status != Status.TERMINATED;
                    this.status = Status.TERMINATED;
                }
                if (invokeEnd) {
                    this.caller.end(ShellResponse.cancelled());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean cancel;
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case CONSTRUCTED: {
                    throw new IllegalStateException("Cannot call cancel on process that was not scheduled for execution yet");
                }
                case QUEUED: {
                    this.status = Status.CANCELED;
                    cancel = false;
                    break;
                }
                case EVALUATING: {
                    this.status = Status.CANCELED;
                    cancel = true;
                    break;
                }
                default: {
                    cancel = false;
                }
            }
        }
        if (cancel) {
            this.callee.cancel();
        }
    }
}

