/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import org.crsh.text.Chunk;
import org.crsh.text.RenderingContext;
import org.crsh.text.Text;

public class RenderWriter
extends Writer
implements RenderingContext {
    private final RenderingContext out;
    private final Closeable closeable;
    private boolean closed;
    private boolean empty;

    public RenderWriter(RenderingContext out) throws NullPointerException {
        this(out, null);
    }

    public RenderWriter(RenderingContext out, Closeable closeable) throws NullPointerException {
        if (out == null) {
            throw new NullPointerException("No null appendable expected");
        }
        this.out = out;
        this.empty = true;
        this.closeable = closeable;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int getWidth() {
        return this.out.getWidth();
    }

    public void provide(Chunk element) throws IOException {
        if (element instanceof Text) {
            Text text = (Text)element;
            this.empty &= text.getText().length() == 0;
        }
        this.out.provide(element);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        if (len > 0) {
            Text text = new Text();
            text.buffer.append(cbuf, off, len);
            this.provide(text);
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.out.flush();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.closeable != null) {
                this.closeable.close();
            }
        }
    }
}

