/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public class AppendableWriter
extends Writer {
    private final Appendable out;
    private final Flushable flushable;
    private final Closeable closeable;
    private boolean closed;
    private boolean empty;

    public AppendableWriter(Appendable out) throws NullPointerException {
        this(out, null, null);
    }

    public AppendableWriter(Appendable out, Flushable flushable) throws NullPointerException {
        this(out, flushable, null);
    }

    public AppendableWriter(Appendable out, Closeable closeable) throws NullPointerException {
        this(out, null, closeable);
    }

    public AppendableWriter(Appendable out, Flushable flushable, Closeable closeable) throws NullPointerException {
        if (out == null) {
            throw new NullPointerException("No null appendable expected");
        }
        this.out = out;
        this.empty = true;
        this.flushable = flushable;
        this.closeable = closeable;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        if (len > 0) {
            this.empty = false;
            int end = off + len;
            while (off < end) {
                this.out.append(cbuf[off++]);
            }
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        if (this.flushable != null) {
            this.flushable.flush();
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.closeable != null) {
                this.closeable.close();
            }
        }
    }
}

