/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.ArrayList;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoaderDiscovery
implements PluginDiscovery {
    private static final Logger log = Logger.getLogger(PluginManager.class.getName());
    private final ClassLoader classLoader;

    public ServiceLoaderDiscovery(ClassLoader classLoader) throws NullPointerException {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
    }

    @Override
    public Iterable<CRaSHPlugin<?>> getPlugins() {
        ArrayList plugins = new ArrayList();
        try {
            ServiceLoader<CRaSHPlugin> loader = ServiceLoader.load(CRaSHPlugin.class, this.classLoader);
            for (CRaSHPlugin plugin : loader) {
                log.log(Level.INFO, "Loaded plugin " + plugin);
                plugins.add(plugin);
            }
        }
        catch (ServiceConfigurationError e) {
            log.log(Level.SEVERE, "Could not load plugins", e);
        }
        return plugins;
    }
}

