/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.crsh.vfs.spi.AbstractFSDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDriver
extends AbstractFSDriver<File> {
    private final File root;

    public FileDriver(File root) throws NullPointerException {
        if (root == null) {
            throw new NullPointerException();
        }
        this.root = root;
    }

    @Override
    public File root() throws IOException {
        return this.root;
    }

    @Override
    public String name(File handle) throws IOException {
        return handle.getName();
    }

    @Override
    public boolean isDir(File handle) throws IOException {
        return handle.isDirectory();
    }

    @Override
    public Iterable<File> children(File handle) throws IOException {
        File[] files = handle.listFiles();
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    @Override
    public long getLastModified(File handle) throws IOException {
        return handle.lastModified();
    }

    @Override
    public InputStream open(File handle) throws IOException {
        return new FileInputStream(handle);
    }
}

