/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.URLKeyPairProvider;
import org.crsh.ssh.term.scp.SCPCommandFactory;
import org.crsh.term.TermLifeCycle;
import org.crsh.term.spi.TermIOHandler;
import org.crsh.vfs.Resource;

public class SSHLifeCycle
extends TermLifeCycle {
    public static final Session.AttributeKey<String> USERNAME = new Session.AttributeKey();
    public static final Session.AttributeKey<String> PASSWORD = new Session.AttributeKey();
    private final Logger log = Logger.getLogger(SSHLifeCycle.class.getName());
    private SshServer server;
    private int port;
    private Resource key;
    private String authentication;

    public SSHLifeCycle(PluginContext context) {
        super(context);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Resource getKey() {
        return this.key;
    }

    public void setKey(Resource key) {
        this.key = key;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    protected void doInit() {
        try {
            TermIOHandler handler = this.getHandler();
            SshServer server = SshServer.setUpDefaultServer();
            server.setPort(this.port);
            server.setShellFactory(new CRaSHCommandFactory(handler));
            server.setCommandFactory(new SCPCommandFactory(this.getContext()));
            server.setKeyPairProvider(new URLKeyPairProvider(this.key));
            AuthenticationPlugin plugin = new AuthenticationPlugin(){

                public String getName() {
                    return "null";
                }

                public boolean authenticate(String username, String password) throws Exception {
                    return false;
                }
            };
            if (this.authentication != null) {
                for (AuthenticationPlugin authenticationPlugin : this.getContext().getPlugins(AuthenticationPlugin.class)) {
                    if (!this.authentication.equals(authenticationPlugin.getName())) continue;
                    plugin = authenticationPlugin;
                    break;
                }
            }
            final AuthenticationPlugin authPlugin = plugin;
            server.setPasswordAuthenticator(new PasswordAuthenticator(){

                public boolean authenticate(String _username, String _password, ServerSession session) {
                    boolean auth;
                    try {
                        SSHLifeCycle.this.log.log(Level.FINE, "Using authentication plugin " + authPlugin + " to authenticate user " + _username);
                        auth = authPlugin.authenticate(_username, _password);
                    }
                    catch (Exception e) {
                        SSHLifeCycle.this.log.log(Level.SEVERE, "Exception authenticating user " + _username + " in authentication plugin: " + authPlugin, e);
                        return false;
                    }
                    session.setAttribute(USERNAME, _username);
                    session.setAttribute(PASSWORD, _password);
                    return auth;
                }
            });
            this.log.log(Level.INFO, "About to start CRaSSHD");
            server.start();
            this.log.log(Level.INFO, "CRaSSHD started on port " + this.port);
            this.server = server;
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Could not start CRaSSHD", e);
        }
    }

    protected void doDestroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.log(Level.FINE, "Got an interruption when stopping server", e);
            }
        }
    }
}

