/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;

public abstract class Element {
    private Style.Composite style = null;

    protected Element() {
    }

    public abstract Renderer renderer();

    public void render(RenderAppendable to) {
        Renderer renderer = this.renderer();
        LineReader reader = renderer.reader(to.getWidth(), to.getHeight() - 1);
        if (reader != null) {
            while (reader.hasLine()) {
                reader.renderLine(to);
                to.append('\n');
            }
        }
    }

    public final Style.Composite getStyle() {
        return this.style;
    }

    public final void setStyle(Style.Composite style) {
        this.style = style;
    }

    public Element style(Style.Composite style) {
        this.setStyle(style);
        return this;
    }

    public static RowElement row() {
        return new RowElement();
    }

    public static RowElement header() {
        return new RowElement(true);
    }

    public static LabelElement label(String value) {
        return new LabelElement(value);
    }
}

