/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;

public final class IvyAuthenticator
extends Authenticator {
    private Authenticator original;
    private static boolean securityWarningLogged = false;

    private IvyAuthenticator(Authenticator original) {
        this.original = original;
    }

    public static void install() {
        block5: {
            Authenticator original = null;
            try {
                Field f = Authenticator.class.getDeclaredField("theAuthenticator");
                f.setAccessible(true);
                original = (Authenticator)f.get(null);
            }
            catch (Throwable t) {
                Message.debug("Error occurred while getting the original authenticator: " + t.getMessage());
            }
            if (!(original instanceof IvyAuthenticator)) {
                try {
                    Authenticator.setDefault(new IvyAuthenticator(original));
                }
                catch (SecurityException e) {
                    if (securityWarningLogged) break block5;
                    securityWarningLogged = true;
                    Message.warn("Not enough permissions to set the IvyAuthenticator. HTTP(S) authentication will be disabled!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication result = null;
        String proxyHost = System.getProperty("http.proxyHost");
        if (this.getRequestingHost().equals(proxyHost)) {
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null && proxyUser.trim().length() > 0) {
                String proxyPass = System.getProperty("http.proxyPassword", "");
                Message.debug("authenicating to proxy server with username [" + proxyUser + "]");
                result = new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            }
        } else {
            Credentials c = CredentialsStore.INSTANCE.getCredentials(this.getRequestingPrompt(), this.getRequestingHost());
            Message.debug("authentication: k='" + Credentials.buildKey(this.getRequestingPrompt(), this.getRequestingHost()) + "' c='" + c + "'");
            if (c != null) {
                result = new PasswordAuthentication(c.getUserName(), c.getPasswd().toCharArray());
            }
        }
        if (result == null && this.original != null) {
            Authenticator.setDefault(this.original);
            try {
                result = Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme());
            }
            finally {
                Authenticator.setDefault(this);
            }
        }
        return result;
    }
}

