/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.plugin.ResourceKind;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.Resource;

class ResourceManager {
    private static final Pattern p = Pattern.compile("(.+)\\.groovy");
    private static final Logger log = Logger.getLogger(ResourceManager.class.getName());
    private final FS cmdFS;
    private final FS confFS;
    private volatile List<File> dirs;

    public ResourceManager(FS cmdFS, FS confFS) {
        this.cmdFS = cmdFS;
        this.confFS = confFS;
    }

    Resource loadResource(String resourceId, ResourceKind resourceKind) {
        Resource res = null;
        try {
            switch (resourceKind) {
                case LIFECYCLE: {
                    if (!"login".equals(resourceId) && !"logout".equals(resourceId)) break;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    long timestamp = Long.MIN_VALUE;
                    for (File path : this.dirs) {
                        Resource sub;
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null || (sub = f.getResource()) == null) continue;
                        buffer.write(sub.getContent());
                        buffer.write(10);
                        timestamp = Math.max(timestamp, sub.getTimestamp());
                    }
                    return new Resource(buffer.toByteArray(), timestamp);
                }
                case COMMAND: {
                    for (File path : this.dirs) {
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null) continue;
                        res = f.getResource();
                    }
                    break;
                }
                case CONFIG: {
                    String path = "/" + resourceId;
                    File file = this.confFS.get(Path.get(path));
                    if (file == null) break;
                    res = file.getResource();
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not obtain resource " + resourceId, e);
        }
        return res;
    }

    List<String> listResourceId(ResourceKind kind) {
        switch (kind) {
            case COMMAND: {
                TreeSet<String> all = new TreeSet<String>();
                try {
                    for (File path : this.dirs) {
                        for (File file : path.children()) {
                            String name = file.getName();
                            Matcher matcher = p.matcher(name);
                            if (!matcher.matches()) continue;
                            all.add(matcher.group(1));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                all.remove("login");
                all.remove("logout");
                return new ArrayList<String>(all);
            }
        }
        return Collections.emptyList();
    }

    void refresh() {
        try {
            File commands = this.cmdFS.get(Path.get("/"));
            ArrayList<File> newDirs = new ArrayList<File>();
            newDirs.add(commands);
            for (File path : commands.children()) {
                if (!path.isDir()) continue;
                newDirs.add(path);
            }
            this.dirs = newDirs;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

