/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.IOException;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.InvocationContext;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ScriptException;
import org.crsh.shell.ScreenContext;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.shell.impl.command.PipeLineFactory;
import org.crsh.shell.impl.command.PipeLineParser;
import org.crsh.text.Chunk;
import org.crsh.text.RenderPrintWriter;

final class InvocationContextImpl<P>
implements InvocationContext<P> {
    private final CommandContext<P> commandContext;
    private RenderPrintWriter writer;

    InvocationContextImpl(CommandContext<P> commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public boolean isPiped() {
        return this.commandContext.isPiped();
    }

    @Override
    public RenderPrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new RenderPrintWriter(new ScreenContext<Chunk>(){

                @Override
                public int getWidth() {
                    return InvocationContextImpl.this.commandContext.getWidth();
                }

                @Override
                public int getHeight() {
                    return InvocationContextImpl.this.commandContext.getHeight();
                }

                @Override
                public Class<Chunk> getConsumedType() {
                    return Chunk.class;
                }

                @Override
                public void provide(Chunk element) throws IOException {
                    Class consumedType = InvocationContextImpl.this.commandContext.getConsumedType();
                    if (consumedType.isInstance(element)) {
                        Object p = consumedType.cast(element);
                        InvocationContextImpl.this.commandContext.provide(p);
                    }
                }

                @Override
                public void flush() throws IOException {
                    InvocationContextImpl.this.commandContext.flush();
                }
            });
        }
        return this.writer;
    }

    @Override
    public boolean takeAlternateBuffer() throws IOException {
        return this.commandContext.takeAlternateBuffer();
    }

    @Override
    public boolean releaseAlternateBuffer() throws IOException {
        return this.commandContext.releaseAlternateBuffer();
    }

    @Override
    public CommandInvoker<?, ?> resolve(String s) throws ScriptException, IOException {
        CRaSHSession session = (CRaSHSession)this.getSession();
        PipeLineParser parser = new PipeLineParser(s);
        PipeLineFactory factory = parser.parse();
        try {
            return factory.create(session);
        }
        catch (NoSuchCommandException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Class<P> getConsumedType() {
        return this.commandContext.getConsumedType();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.commandContext.getProperty(propertyName);
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return this.commandContext.readLine(msg, echo);
    }

    @Override
    public int getWidth() {
        return this.commandContext.getWidth();
    }

    @Override
    public int getHeight() {
        return this.commandContext.getHeight();
    }

    @Override
    public void provide(P element) throws IOException {
        this.commandContext.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.commandContext.flush();
    }

    @Override
    public void close() throws IOException {
        this.commandContext.close();
    }

    @Override
    public Map<String, Object> getSession() {
        return this.commandContext.getSession();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.commandContext.getAttributes();
    }

    public InvocationContextImpl<P> leftShift(Object o) throws IOException {
        if (this.commandContext.getConsumedType().isInstance(o)) {
            Object p = this.commandContext.getConsumedType().cast(o);
            this.commandContext.provide(p);
        }
        return this;
    }
}

