/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.completion;

import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.Completion;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;

class CommandCompletion<T>
extends Completion {
    private final CommandDescriptor<T> descriptor;
    private final String mainName;
    private final String prefix;
    private final Delimiter delimiter;

    CommandCompletion(CommandDescriptor<T> descriptor, String mainName, String prefix, Delimiter delimiter) {
        this.descriptor = descriptor;
        this.mainName = mainName;
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    @Override
    public CompletionMatch complete() throws CompletionException {
        Completion.Builder builder = org.crsh.cli.spi.Completion.builder(this.prefix);
        for (CommandDescriptor<T> m : this.descriptor.getSubordinates().values()) {
            String name = m.getName();
            if (!name.startsWith(this.prefix) || name.equals(this.mainName)) continue;
            builder.add(name.substring(this.prefix.length()), true);
        }
        return new CompletionMatch(this.delimiter, builder.build());
    }
}

