/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.tokenizer;

import org.crsh.cli.impl.tokenizer.Escape;
import org.crsh.cli.impl.tokenizer.Status;

class State {
    StringBuilder buffer = new StringBuilder();
    Escape escape;
    Status status = Status.INIT;

    public State() {
        this.escape = Escape.NONE;
    }

    void push(char c) {
        switch (this.escape) {
            case NONE: {
                if (c == '\"') {
                    this.escape = Escape.DOUBLE;
                    return;
                }
                if (c == '\\') {
                    this.escape = Escape.BACKSLASH;
                    return;
                }
                if (c != '\'') break;
                this.escape = Escape.SINGLE;
                return;
            }
            case DOUBLE: {
                if (c != '\"') break;
                this.escape = Escape.NONE;
                return;
            }
            case SINGLE: {
                if (c != '\'') break;
                this.escape = Escape.NONE;
                return;
            }
            case BACKSLASH: {
                this.escape = Escape.NONE;
                break;
            }
            default: {
                throw new AssertionError((Object)this.escape);
            }
        }
        switch (this.status) {
            case INIT: {
                if (c == '-') {
                    this.buffer.append(c);
                    this.status = Status.SHORT_OPTION;
                    return;
                }
                this.buffer.append(c);
                this.status = Status.WORD;
                return;
            }
            case WORD: {
                this.buffer.append(c);
                this.status = Status.WORD;
                return;
            }
            case SHORT_OPTION: {
                if (Character.isLetter(c)) {
                    this.buffer.append(c);
                    return;
                }
                if (c == '-') {
                    this.buffer.append('-');
                    this.status = Status.LONG_OPTION;
                    return;
                }
                this.buffer.append(c);
                this.status = Status.WORD;
                return;
            }
            case LONG_OPTION: {
                if (Character.isLetter(c) || this.buffer.length() > 0 && c == '-') {
                    this.buffer.append(c);
                    return;
                }
                this.buffer.append(c);
                this.status = Status.WORD;
                return;
            }
        }
        throw new AssertionError((Object)this.escape);
    }
}

