/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.net;

import java.util.Vector;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.TerminalIO;
import net.wimpi.telnetd.net.ConnectionData;
import net.wimpi.telnetd.net.ConnectionEvent;
import net.wimpi.telnetd.net.ConnectionListener;
import net.wimpi.telnetd.shell.Shell;
import net.wimpi.telnetd.shell.ShellManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connection
extends Thread {
    private static Log log = LogFactory.getLog(Connection.class);
    private static int m_Number;
    private boolean m_Dead;
    private Vector m_Listeners;
    private ConnectionData m_ConnectionData;
    private BasicTerminalIO m_TerminalIO;
    private Shell m_NextShell = null;

    public Connection(ThreadGroup tcg, ConnectionData cd) {
        super(tcg, "Connection" + ++m_Number);
        this.m_ConnectionData = cd;
        this.m_Listeners = new Vector(3);
        this.m_TerminalIO = new TerminalIO(this);
        this.m_Dead = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean done = false;
        try {
            Shell sh = ShellManager.getReference().getShell(this.m_ConnectionData.getLoginShell());
            do {
                sh.run(this);
                if (this.m_Dead) {
                    done = true;
                    break;
                }
                sh = this.getNextShell();
                if (sh != null) continue;
                done = true;
            } while (!done || this.m_Dead);
        }
        catch (Exception ex) {
            log.error("run()", ex);
        }
        finally {
            if (!this.m_Dead) {
                this.close();
            }
        }
        log.debug("run():: Returning from " + this.toString());
    }

    public ConnectionData getConnectionData() {
        return this.m_ConnectionData;
    }

    public BasicTerminalIO getTerminalIO() {
        return this.m_TerminalIO;
    }

    public boolean setNextShell(String name) {
        this.m_NextShell = ShellManager.getReference().getShell(name);
        return this.m_NextShell != null;
    }

    private Shell getNextShell() {
        Shell shell = this.m_NextShell;
        if (shell != null) {
            this.m_NextShell = null;
            return shell;
        }
        return null;
    }

    public synchronized void close() {
        if (this.m_Dead) {
            return;
        }
        try {
            this.m_Dead = true;
            this.m_TerminalIO.close();
        }
        catch (Exception ex) {
            log.error("close()", ex);
        }
        try {
            this.m_ConnectionData.getSocket().close();
        }
        catch (Exception ex) {
            log.error("close()", ex);
        }
        try {
            this.m_ConnectionData.getManager().registerClosedConnection(this);
        }
        catch (Exception ex) {
            log.error("close()", ex);
        }
        try {
            this.interrupt();
        }
        catch (Exception ex) {
            log.error("close()", ex);
        }
        log.debug("Closed " + this.toString() + " and inactive.");
    }

    public boolean isActive() {
        return !this.m_Dead;
    }

    public void addConnectionListener(ConnectionListener cl) {
        this.m_Listeners.addElement(cl);
    }

    public void removeConnectionListener(ConnectionListener cl) {
        this.m_Listeners.removeElement(cl);
    }

    public void processConnectionEvent(ConnectionEvent ce) {
        for (int i = 0; i < this.m_Listeners.size(); ++i) {
            ConnectionListener cl = (ConnectionListener)this.m_Listeners.elementAt(i);
            if (ce.isType(100)) {
                cl.connectionIdle(ce);
                continue;
            }
            if (ce.isType(101)) {
                cl.connectionTimedOut(ce);
                continue;
            }
            if (ce.isType(102)) {
                cl.connectionLogoutRequest(ce);
                continue;
            }
            if (!ce.isType(104)) continue;
            cl.connectionSentBreak(ce);
        }
    }
}

