/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.plugin.ResourceKind;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.Resource;

public class ResourceManager {
    private static final Pattern p = Pattern.compile("(.+)\\.groovy");
    private static final Logger log = Logger.getLogger(ResourceManager.class.getName());
    private final FS cmdFS;
    private final FS confFS;
    private volatile List<File> dirs;
    private static final byte[] SEPARATOR = System.getProperty("line.separator").getBytes();

    ResourceManager(FS cmdFS, FS confFS) {
        this.cmdFS = cmdFS;
        this.confFS = confFS;
    }

    Resource loadResource(String resourceId, ResourceKind resourceKind) {
        Resource res = null;
        try {
            switch (resourceKind) {
                case LIFECYCLE: {
                    if (!"login".equals(resourceId) && !"logout".equals(resourceId)) break;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    long timestamp = Long.MIN_VALUE;
                    for (File path : this.dirs) {
                        Resource sub;
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null || (sub = f.getResource()) == null) continue;
                        buffer.write(sub.getContent());
                        buffer.write(10);
                        timestamp = Math.max(timestamp, sub.getTimestamp());
                    }
                    return new Resource(buffer.toByteArray(), timestamp);
                }
                case COMMAND: {
                    for (File path : this.dirs) {
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null) continue;
                        res = f.getResource();
                    }
                    break;
                }
                case CONFIG: {
                    String path = "/" + resourceId;
                    File file = this.confFS.get(Path.get(path));
                    if (file == null) break;
                    res = ResourceManager.loadConf(file);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not obtain resource " + resourceId, e);
        }
        return res;
    }

    List<String> listResourceId(ResourceKind kind) {
        switch (kind) {
            case COMMAND: {
                TreeSet<String> all = new TreeSet<String>();
                try {
                    for (File path : this.dirs) {
                        for (File file : path.children()) {
                            String name = file.getName();
                            Matcher matcher = p.matcher(name);
                            if (!matcher.matches()) continue;
                            all.add(matcher.group(1));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                all.remove("login");
                all.remove("logout");
                return new ArrayList<String>(all);
            }
        }
        return Collections.emptyList();
    }

    void refresh() {
        try {
            File commands = this.cmdFS.get(Path.get("/"));
            ArrayList<File> newDirs = new ArrayList<File>();
            newDirs.add(commands);
            for (File path : commands.children()) {
                if (!path.isDir()) continue;
                newDirs.add(path);
            }
            this.dirs = newDirs;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Resource loadConf(File file) throws IOException {
        if (file.getName().endsWith(".properties")) {
            Iterator<Resource> i = file.getResources().iterator();
            if (i.hasNext()) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                long timestamp = 0L;
                while (i.hasNext()) {
                    Resource resource = i.next();
                    byte[] bytes = resource.getContent();
                    buffer.write(bytes);
                    timestamp = Math.max(timestamp, resource.getTimestamp());
                    if (!i.hasNext()) continue;
                    buffer.write(SEPARATOR);
                    buffer.write(SEPARATOR);
                }
                return new Resource(buffer.toByteArray(), timestamp);
            }
            return null;
        }
        return file.getResource();
    }
}

