/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.util.Iterator;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;

public abstract class Renderer {
    public static final Renderer NULL = new Renderer(){

        @Override
        public int getActualWidth() {
            return 0;
        }

        @Override
        public int getMinWidth() {
            return 0;
        }

        @Override
        public int getMinHeight(int width) {
            return 0;
        }

        @Override
        public int getActualHeight(int width) {
            return 0;
        }

        @Override
        public LineReader reader(int width) {
            return new LineReader(){

                @Override
                public boolean hasLine() {
                    return false;
                }

                @Override
                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    throw new IllegalStateException();
                }
            };
        }
    };

    public static Renderer vertical(Iterable<? extends Renderer> renderers) {
        Iterator<? extends Renderer> i = renderers.iterator();
        if (i.hasNext()) {
            Renderer renderer = i.next();
            if (i.hasNext()) {
                return new Composite(renderers);
            }
            return renderer;
        }
        return NULL;
    }

    public abstract int getActualWidth();

    public abstract int getMinWidth();

    public abstract int getMinHeight(int var1);

    public abstract int getActualHeight(int var1);

    public LineReader reader(int width, int height) {
        if (height > 0) {
            return null;
        }
        return this.reader(width);
    }

    public abstract LineReader reader(int var1);

    public final void render(RenderAppendable out) {
        LineReader renderer = this.reader(out.getWidth());
        if (renderer != null) {
            while (renderer.hasLine()) {
                renderer.renderLine(out);
                out.append('\n');
            }
        }
    }

    private static class Composite
    extends Renderer {
        private final Iterable<? extends Renderer> renderers;
        private final int actualWidth;
        private final int minWidth;

        private Composite(Iterable<? extends Renderer> renderers) {
            int actualWidth = 0;
            int minWidth = 0;
            for (Renderer renderer : renderers) {
                actualWidth = Math.max(actualWidth, renderer.getActualWidth());
                minWidth = Math.max(minWidth, renderer.getMinWidth());
            }
            this.actualWidth = actualWidth;
            this.minWidth = minWidth;
            this.renderers = renderers;
        }

        @Override
        public int getActualWidth() {
            return this.actualWidth;
        }

        @Override
        public int getMinWidth() {
            return this.minWidth;
        }

        @Override
        public int getActualHeight(int width) {
            int actualHeight = 0;
            for (Renderer renderer : this.renderers) {
                actualHeight += renderer.getActualHeight(width);
            }
            return actualHeight;
        }

        @Override
        public int getMinHeight(int width) {
            return 1;
        }

        @Override
        public LineReader reader(final int width, final int height) {
            final Iterator<? extends Renderer> i = this.renderers.iterator();
            return new LineReader(){
                private LineReader current;
                private int index = 0;

                @Override
                public boolean hasLine() {
                    if (height > 0 && this.index >= height) {
                        return false;
                    }
                    if (this.current == null || !this.current.hasLine()) {
                        while (i.hasNext()) {
                            Renderer next = (Renderer)i.next();
                            LineReader reader = next.reader(width);
                            if (reader == null || !reader.hasLine()) continue;
                            this.current = reader;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    if (this.hasLine()) {
                        this.current.renderLine(to);
                        ++this.index;
                    } else {
                        throw new IllegalStateException();
                    }
                }
            };
        }

        @Override
        public LineReader reader(int width) {
            return this.reader(width, -1);
        }
    }
}

