/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.renderers;

import java.util.Iterator;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;

public class BindingRenderable
extends Renderable<BindingData> {
    @Override
    public Class<BindingData> getType() {
        return BindingData.class;
    }

    @Override
    public Renderer renderer(Iterator<BindingData> stream) {
        TableElement table = new TableElement();
        table.setRightCellPadding(1);
        RowElement header = new RowElement(true);
        header.add(new LabelElement("NAME"));
        table.add(header);
        while (stream.hasNext()) {
            BindingData binding = stream.next();
            RowElement row = new RowElement();
            row.add(new LabelElement(binding.name));
            if (binding.verbose.booleanValue()) {
                row.add(new LabelElement(binding.type));
                if (header.getSize() == 1) {
                    header.add(new LabelElement("CLASS"));
                }
            }
            table.add(row);
        }
        return table.renderer();
    }

    public static class BindingData {
        public final String name;
        public final String type;
        public final Object instance;
        public final Boolean verbose;

        public BindingData(String name, String type, Object instance, Boolean verbose) {
            this.name = name;
            this.type = type;
            this.instance = instance;
            this.verbose = verbose != null ? verbose : false;
        }
    }
}

