/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.renderers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.Layout;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;

public class EntityTypeRenderable
extends Renderable<EntityTypeData> {
    @Override
    public Class<EntityTypeData> getType() {
        return EntityTypeData.class;
    }

    @Override
    public Renderer renderer(Iterator<EntityTypeData> stream) {
        TableElement table = new TableElement();
        table.setRightCellPadding(1);
        while (stream.hasNext()) {
            EntityTypeData entityTypeData = stream.next();
            if (!entityTypeData.verbose) {
                if (table.getRows().size() == 0) {
                    RowElement header = new RowElement(true);
                    header.add(new LabelElement("NAME"), new LabelElement("TYPE"));
                    table.add(header);
                }
                RowElement row = new RowElement();
                row.add(new LabelElement(entityTypeData.name), new LabelElement(entityTypeData.type));
                table.add(row);
                continue;
            }
            table.setColumnLayout(Layout.weighted(1));
            RowElement name = new RowElement();
            name.add(new LabelElement("Name : " + entityTypeData.name));
            table.add(name);
            RowElement type = new RowElement();
            type.add(new LabelElement("Type : " + entityTypeData.type));
            table.add(type);
            RowElement mapping = new RowElement();
            mapping.add(new LabelElement("Mapping : " + entityTypeData.mapping));
            table.add(mapping);
            if (entityTypeData.attributes.size() <= 0) continue;
            RowElement attributesLabel = new RowElement();
            attributesLabel.add(new LabelElement("Attributes : "));
            table.add(attributesLabel);
            TableElement attributeTable = new TableElement();
            attributeTable.setRightCellPadding(1);
            RowElement attributeRowHeader = new RowElement(true);
            attributeRowHeader.add(new LabelElement("NAME"), new LabelElement("TYPE"), new LabelElement("ASSOCIATION"), new LabelElement("COLLECTION"), new LabelElement("MAPPING"));
            attributeTable.add(attributeRowHeader);
            for (AttributeData attributes : entityTypeData.attributes) {
                RowElement row = new RowElement();
                row.add(new LabelElement(attributes.name), new LabelElement(attributes.type), new LabelElement(attributes.association), new LabelElement(attributes.collection), new LabelElement(attributes.mapping));
                attributeTable.add(row);
            }
            RowElement attributesRow = new RowElement();
            attributesRow.add(attributeTable);
            table.add(attributesRow);
        }
        return table.renderer();
    }

    public static class AttributeData {
        public final String name;
        public final String type;
        public final Boolean association;
        public final Boolean collection;
        public final String mapping;

        public AttributeData(String name, String type, Boolean association, Boolean collection, String mapping) {
            this.name = name;
            this.type = type;
            this.association = association != null ? association : false;
            this.collection = collection != null ? collection : false;
            this.mapping = mapping;
        }
    }

    public static class EntityTypeData {
        public final String name;
        public final String type;
        public final String mapping;
        public final boolean verbose;
        public final List<AttributeData> attributes;

        public EntityTypeData(String name, String type, String mapping) {
            this(name, type, mapping, false);
        }

        public EntityTypeData(String name, String type, String mapping, boolean verbose) {
            this.name = name;
            this.type = type;
            this.mapping = mapping;
            this.verbose = verbose;
            this.attributes = new ArrayList<AttributeData>();
        }

        public void add(AttributeData d) {
            this.attributes.add(d);
        }
    }
}

