/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.parser;

import java.util.ArrayList;
import java.util.List;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.tokenizer.Token;

public abstract class Event {

    public static abstract class Stop
    extends Event {
        public abstract int getIndex();

        public static abstract class Unresolved<T extends Token>
        extends Stop {
            private final T token;

            Unresolved(T token) {
                this.token = token;
            }

            @Override
            public final int getIndex() {
                return ((Token)this.token).getFrom();
            }

            public T getToken() {
                return this.token;
            }

            public static final class TooManyArguments
            extends Unresolved<Token.Literal> {
                TooManyArguments(Token.Literal token) {
                    super(token);
                }
            }

            public static final class NoSuchOption
            extends Unresolved<Token.Literal.Option> {
                public NoSuchOption(Token.Literal.Option token) {
                    super(token);
                }
            }
        }

        public static final class Done
        extends Stop {
            private final int index;

            Done(int index) {
                this.index = index;
            }

            @Override
            public int getIndex() {
                return this.index;
            }
        }
    }

    public static abstract class Subordinate
    extends Event {
        private final CommandDescriptor<?> descriptor;

        Subordinate(CommandDescriptor<?> descriptor) {
            this.descriptor = descriptor;
        }

        public CommandDescriptor<?> getDescriptor() {
            return this.descriptor;
        }

        public static final class Explicit
        extends Subordinate {
            private final Token.Literal.Word token;

            public Explicit(CommandDescriptor<?> descriptor, Token.Literal.Word token) {
                super(descriptor);
                this.token = token;
            }

            public Token.Literal.Word getToken() {
                return this.token;
            }
        }

        public static final class Implicit
        extends Subordinate {
            private final Token.Literal trigger;

            public Implicit(CommandDescriptor<?> descriptor, Token.Literal trigger) {
                super(descriptor);
                this.trigger = trigger;
            }

            public Token.Literal getTrigger() {
                return this.trigger;
            }
        }
    }

    public static final class Separator
    extends Event {
        private final Token.Whitespace token;

        Separator(Token.Whitespace token) {
            this.token = token;
        }

        public Token.Whitespace getToken() {
            return this.token;
        }
    }

    public static final class Argument
    extends Parameter<Token.Literal, ArgumentDescriptor> {
        Argument(CommandDescriptor<?> command, ArgumentDescriptor descriptor, List<Token.Literal> values) throws IllegalArgumentException {
            super(command, descriptor, values);
            if (values.size() == 0) {
                throw new IllegalArgumentException("No empty values");
            }
        }

        @Override
        public int getFrom() {
            return ((Token)this.peekFirst()).getFrom();
        }

        @Override
        public int getTo() {
            return ((Token)this.peekLast()).getTo();
        }
    }

    public static final class Option
    extends Parameter<Token.Literal.Word, OptionDescriptor> {
        private final Token.Literal.Option token;

        Option(CommandDescriptor<?> command, OptionDescriptor descriptor, Token.Literal.Option token, List<Token.Literal.Word> values) {
            super(command, descriptor, values);
            this.token = token;
        }

        public final Token.Literal.Option getToken() {
            return this.token;
        }

        @Override
        public int getFrom() {
            return this.token.getFrom();
        }

        @Override
        public int getTo() {
            return this.values.size() == 0 ? this.token.getTo() : ((Token.Literal.Word)this.peekLast()).getTo();
        }
    }

    public static abstract class Parameter<T extends Token.Literal, D extends ParameterDescriptor>
    extends Event {
        protected final CommandDescriptor<?> command;
        protected final D parameter;
        protected final List<T> values;

        public Parameter(CommandDescriptor<?> command, D parameter, List<T> values) {
            this.command = command;
            this.parameter = parameter;
            this.values = values;
        }

        public CommandDescriptor<?> getCommand() {
            return this.command;
        }

        public final D getParameter() {
            return this.parameter;
        }

        public final List<T> getValues() {
            return this.values;
        }

        public final T peekFirst() {
            return (T)(this.values.isEmpty() ? null : (Token.Literal)this.values.get(0));
        }

        public final T peekLast() {
            int size = this.values.size();
            return (T)(size == 0 ? null : (Token.Literal)this.values.get(size - 1));
        }

        public final List<String> getStrings() {
            ArrayList<String> strings = new ArrayList<String>();
            for (Token.Literal value : this.values) {
                strings.add(value.getValue());
            }
            return strings;
        }

        public abstract int getFrom();

        public abstract int getTo();

        public String toString() {
            return this.getClass().getSimpleName() + "[descriptor=" + this.parameter + ",values=" + this.values + "]";
        }
    }
}

