/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.script;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.command.CommandInvoker;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ShellCommand;
import org.crsh.command.pipeline.PipeLine;
import org.crsh.repl.REPLSession;
import org.crsh.text.Chunk;

public class PipeLineFactory {
    final String line;
    final String name;
    final String rest;
    final PipeLineFactory next;

    public String getLine() {
        return this.line;
    }

    public PipeLineFactory getNext() {
        return this.next;
    }

    public PipeLineFactory(String line, PipeLineFactory next) {
        Pattern p = Pattern.compile("^\\s*(\\S+)");
        Matcher m = p.matcher(line);
        String name = null;
        String rest = null;
        if (m.find()) {
            name = m.group(1);
            rest = line.substring(m.end());
        }
        this.name = name;
        this.rest = rest;
        this.line = line;
        this.next = next;
    }

    public CommandInvoker<Void, Chunk> create(REPLSession session) throws NoSuchCommandException {
        LinkedList pipes = new LinkedList();
        PipeLineFactory current = this;
        while (current != null) {
            ShellCommand command;
            CommandInvoker<?, ?> commandInvoker = null;
            if (current.name != null && (command = session.getCommand(current.name)) != null) {
                commandInvoker = command.resolveInvoker(current.rest);
            }
            if (commandInvoker == null) {
                throw new NoSuchCommandException(current.name);
            }
            pipes.add(commandInvoker);
            current = current.next;
        }
        return new PipeLine(pipes.toArray(new CommandInvoker[pipes.size()]));
    }

    public PipeLineFactory getLast() {
        if (this.next != null) {
            return this.next.getLast();
        }
        return this;
    }
}

