/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ClientMessage;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.shell.impl.remoting.ServerProcess;
import org.crsh.util.CloseableList;

public class ServerAutomaton
implements Shell {
    final Logger log = Logger.getLogger(ServerAutomaton.class.getName());
    final ObjectInputStream in;
    final ObjectOutputStream out;
    ServerProcess process;
    final CloseableList listeners;

    public ServerAutomaton(ObjectOutputStream out, ObjectInputStream in) {
        CloseableList listeners = new CloseableList();
        listeners.add(in);
        listeners.add(out);
        this.in = in;
        this.out = out;
        this.listeners = listeners;
    }

    public ServerAutomaton(InputStream in, OutputStream out) throws IOException {
        this(new ObjectOutputStream(out), new ObjectInputStream(in));
    }

    public ServerAutomaton addCloseListener(Closeable closeable) {
        this.listeners.add(closeable);
        return this;
    }

    @Override
    public String getWelcome() {
        try {
            this.out.writeObject(new ClientMessage.GetWelcome());
            this.out.flush();
            return ((ServerMessage.Welcome)this.in.readObject()).value;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public String getPrompt() {
        try {
            this.out.writeObject(new ClientMessage.GetPrompt());
            this.out.flush();
            return ((ServerMessage.Prompt)this.in.readObject()).value;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public ShellProcess createProcess(String request) throws IllegalStateException {
        return new ServerProcess(this, request);
    }

    @Override
    public CompletionMatch complete(String prefix) {
        try {
            this.out.writeObject(new ClientMessage.GetCompletion(prefix));
            this.out.flush();
            return ((ServerMessage.Completion)this.in.readObject()).value;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void close() {
        this.listeners.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ServerProcess process, ShellProcessContext processContext) throws IllegalStateException {
        if (this.process != null) {
            throw new IllegalStateException();
        }
        this.process = process;
        ShellResponse response = null;
        try {
            this.out.writeObject(new ClientMessage.Execute(processContext.getWidth(), processContext.getHeight(), process.line));
            this.out.flush();
            while (response == null) {
                ServerMessage msg = (ServerMessage)this.in.readObject();
                if (msg instanceof ServerMessage.GetSize) {
                    this.out.writeObject(new ClientMessage.SetSize(processContext.getWidth(), processContext.getHeight()));
                    this.out.flush();
                    continue;
                }
                if (msg instanceof ServerMessage.ReadLine) {
                    throw new UnsupportedOperationException("Not handled");
                }
                if (msg instanceof ServerMessage.UseAlternateBuffer) {
                    processContext.takeAlternateBuffer();
                    continue;
                }
                if (msg instanceof ServerMessage.UseMainBuffer) {
                    processContext.releaseAlternateBuffer();
                    continue;
                }
                if (msg instanceof ServerMessage.End) {
                    response = ((ServerMessage.End)msg).response;
                    continue;
                }
                if (msg instanceof ServerMessage.Chunk) {
                    processContext.write(((ServerMessage.Chunk)msg).payload);
                    continue;
                }
                if (msg instanceof ServerMessage.Flush) {
                    processContext.flush();
                    continue;
                }
                response = ShellResponse.internalError("Unexpected");
            }
            this.process = null;
            if (response != null) {
                processContext.end(response);
            } else {
                processContext.end(ShellResponse.internalError(""));
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, "Remoting issue", e);
                response = ShellResponse.internalError("Remoting issue", e);
                this.process = null;
                if (response != null) {
                    processContext.end(response);
                } else {
                    processContext.end(ShellResponse.internalError(""));
                }
            }
            catch (Throwable throwable) {
                this.process = null;
                if (response != null) {
                    processContext.end(response);
                } else {
                    processContext.end(ShellResponse.internalError(""));
                }
                throw throwable;
            }
        }
    }

    void cancel(ServerProcess process) throws IllegalStateException {
        if (process == this.process) {
            this.process = null;
            try {
                this.out.writeObject(new ClientMessage.Cancel());
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

