/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.util.LinkedList;
import org.crsh.shell.ScreenContext;
import org.crsh.text.Chunk;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.Text;

public class ChunkAdapter
implements ScreenContext {
    private final LinkedList<Object> buffer = new LinkedList();
    private Renderable renderable = null;
    private final RenderAppendable out;

    public ChunkAdapter(ScreenContext out) {
        this.out = new RenderAppendable(out);
    }

    @Override
    public int getWidth() {
        return this.out.getWidth();
    }

    @Override
    public int getHeight() {
        return this.out.getHeight();
    }

    public Class<Object> getConsumedType() {
        return Object.class;
    }

    @Override
    public void write(Chunk chunk) throws IOException {
        this.provide(chunk);
    }

    public void provide(Object element) throws IOException {
        Renderable<?> current = Renderable.getRenderable(element.getClass());
        if (current == null) {
            this.send();
            if (element instanceof Chunk) {
                this.out.write((Chunk)element);
            } else {
                this.out.write(Text.create(element.toString()));
            }
        } else {
            if (this.renderable != null && !current.equals(this.renderable)) {
                this.send();
            }
            this.buffer.addLast(element);
            this.renderable = current;
        }
    }

    @Override
    public void flush() throws IOException {
        this.send();
        this.out.flush();
    }

    public void send() throws IOException {
        if (this.buffer.size() > 0) {
            Renderer renderer = this.renderable.renderer(this.buffer.iterator());
            renderer.render(this.out);
            this.buffer.clear();
            this.renderable = null;
        }
    }
}

