/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import groovy.lang.GroovyShell;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import junit.framework.TestCase;
import org.crsh.jcr.shell.GroovyRepositoryBootstrap;

public class NodeMetaClassTestCase
extends TestCase {
    private Session session;
    private GroovyShell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.session = GroovyRepositoryBootstrap.getRepository().login((Credentials)new SimpleCredentials("exo", new char[]{'e', 'x', 'o'}));
        this.shell = new GroovyShell();
        this.shell.setVariable("session", (Object)this.session);
    }

    protected void tearDown() throws Exception {
        this.session.logout();
        this.session = null;
        this.shell = null;
    }

    public void testNodeGetName() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\nNode foo = root.addNode('foo');\nassert foo.name == 'foo';\n");
    }

    public void testMissingMethod() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\ntry {\n  root.someNonExistingMethod();\n  assert false;\n}\ncatch (MissingMethodException e) { }\n");
    }

    public void testChildNode() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\nNode foo = root.addNode('foo');\nassert root.foo.getPath() == foo.getPath();\n");
    }

    public void testEach() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\nNode foo = root.addNode('foo');\ndef nodes = [:];\nroot.each({ node ->\n  nodes[node.name] = node;\n});\nassert nodes.containsKey('foo');\n");
    }

    public void testEachWithIndex() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\nNode foo = root.addNode('foo');\ndef nodes = [:];\nroot.eachWithIndex({ node, index ->\n  nodes[node.name] = node;\n});\nassert nodes.containsKey('foo');\n");
    }

    public void testNodeSubscript() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\nNode foo = root.addNode('foo');\ndef nodes = [:];\nroot.getNodes().eachWithIndex({ Node child, int index ->\n  assert child.path == root[index].path;\n  int indexComplement = index - root.getNodes().size();\n  assert child.getPath() == root[indexComplement].getPath();\n});\n");
    }

    public void testEachProperty() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nroot.setProperty('bar', 'bar_value');\ndef properties = [:];\nroot.eachProperty({ property ->\n  properties[property.name] = property;\n});\nassert properties.containsKey('bar');\n");
    }

    public void testPropertyNamePrefix() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nNode res = root.addNode('res', 'nt:resource');\nres['jcr:encoding'] = 'foo_encoding';\nassert res['jcr:encoding'] == 'foo_encoding';\nProperty encodingProperty = res.getProperty('jcr:encoding');\nassert encodingProperty != null;\n assert 'foo_encoding' == encodingProperty.getString();\n");
    }

    public void testNodeNamePrefix() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nNode root = session.getRootNode();\nNode file = root.addNode('file', 'nt:file');\nNode content = file.addNode('jcr:content', 'nt:folder');\nassert content.getPath() == file['jcr:content'].getPath();\n");
    }

    public void testByte1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nbyte barByte = 123;\nroot.barByte = barByte;\nassert root.barByte instanceof Long;\nassert root.barByte == 123L;\nProperty barByteProperty = root.getProperty('barByte');\nassert barByteProperty != null;\nassert 123L == barByteProperty.getLong();\n");
    }

    public void testInteger1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nint barInteger = 123;\nroot.barInteger = barInteger;\nassert root.barInteger instanceof Long;\nassert root.barInteger == 123L;\nProperty barIntegerProperty = root.getProperty('barInteger');\nassert barIntegerProperty != null;\nassert 123L == barIntegerProperty.getLong();\n");
    }

    public void testLong1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nlong barLong = 123;\nroot.barLong = barLong;\nassert root.barLong instanceof Long;\nassert root.barLong == 123L;\nProperty barLongProperty = root.getProperty('barLong');\nassert barLong != null;\nassert 123L == barLongProperty.getLong();root.barLong = '456';assert 456L == barLongProperty.getLong();\n");
    }

    public void testBigInteger1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nBigInteger barInteger = 123;\nroot.barInteger = barInteger;\nassert root.barInteger instanceof Long;\nassert root.barInteger == 123L;\nProperty barIntegerProperty = root.getProperty('barInteger');\nassert barIntegerProperty != null;\nassert 123L == barIntegerProperty.getLong();\n");
    }

    public void testString1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nString barString = '123';\nroot.barString = barString;\nassert root.barString instanceof String;\nassert root.barString == '123';\nProperty barStringProperty = root.getProperty('barString');\nassert barStringProperty != null;\nassert '123' == barStringProperty.getString();\n");
    }

    public void testChar1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nchar barCharacter = 'c';\nroot.barCharacter = barCharacter;\nassert root.barCharacter instanceof String;\nassert root.barCharacter == 'c';\nProperty barCharacterProperty = root.getProperty('barCharacter');\nassert barCharacterProperty != null;\nassert 'c' == barCharacterProperty.getString();\n");
    }

    public void testBoolean1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nboolean barBoolean = true;\nroot.barBoolean = barBoolean;\nassert root.barBoolean instanceof Boolean;\nassert root.barBoolean == true;\nProperty barBooleanProperty = root.getProperty('barBoolean');\nassert barBooleanProperty != null;\nassert true == barBooleanProperty.getBoolean();\n");
    }

    public void testCalendar1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nimport java.util.Calendar;\nNode root = session.getRootNode();\nCalendar now = Calendar.getInstance();\nroot.barCalendar = now;\nassert root.barCalendar instanceof Calendar;\nassert root.barCalendar == now;\nProperty barCalendarProperty = root.getProperty('barCalendar');\nassert barCalendarProperty != null;\nassert now == barCalendarProperty.getDate();\n");
    }

    public void testDouble1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\ndouble barDouble = 0.5D;\nroot.barDouble = barDouble;\nassert root.barDouble instanceof Double;\nassert root.barDouble == 0.5D;\nProperty barDoubleProperty = root.getProperty('barDouble');\nassert barDoubleProperty != null;\nassert 0.5D == barDoubleProperty.getDouble();\n");
    }

    public void testFloat1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nfloat barFloat = 0.5D;\nroot.barFloat = barFloat;\nassert root.barFloat instanceof Double;\nassert root.barFloat == 0.5D;\nProperty barFloatProperty = root.getProperty('barFloat');\nassert barFloatProperty != null;\nassert 0.5D == barFloatProperty.getDouble();\n");
    }

    public void testDecimal1() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\nimport javax.jcr.Property;\nNode root = session.getRootNode();\nBigDecimal barBD = new BigDecimal(0.5);\nroot.barBD = barBD;\nassert root.barBD instanceof Double;\nassert root.barBD == 0.5D;\nProperty barBDProperty = root.getProperty('barBD');\nassert barBDProperty != null;\nassert 0.5D == barBDProperty.getDouble();\n");
    }

    public void testBilto() throws Exception {
        this.shell.evaluate("import javax.jcr.Node;\n;\n;\n");
    }
}

