/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.shell;

import org.crsh.jcr.shell.AbstractJCRCommandTestCase;

public class RemovePropertyTestCase
extends AbstractJCRCommandTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.assertLogin();
    }

    public void tearDown() throws Exception {
        this.groovyShell.evaluate("session.rootNode.getNode('foo').remove();");
        super.tearDown();
    }

    public void testRemoveSingleExisting() throws Exception {
        this.groovyShell.evaluate("session.rootNode.addNode('foo').setProperty('bar', 'foobar');");
        RemovePropertyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasProperty('bar')"));
        this.assertOk("cd foo");
        this.assertOk("node set bar");
        RemovePropertyTestCase.assertEquals((Object)false, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasProperty('bar')"));
    }

    public void testRemoveMultipleExisting() throws Exception {
        this.groovyShell.evaluate("session.rootNode.addNode('foo').setProperty('bar', ['foobar1', 'foobar2'].toArray(new String()[]));");
        RemovePropertyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasProperty('bar')"));
        this.assertOk("cd foo");
        this.assertOk("node set bar");
        RemovePropertyTestCase.assertEquals((Object)false, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasProperty('bar')"));
    }

    public void testRemoveMissing() throws Exception {
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        RemovePropertyTestCase.assertEquals((Object)false, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasProperty('bar')"));
        this.assertOk("cd foo");
        this.assertOk("node set bar");
        RemovePropertyTestCase.assertEquals((Object)false, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasProperty('bar')"));
    }
}

