/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.command;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.completers.AbstractPathCompleter;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.ValueCompletion;
import org.crsh.command.CRaSHCommand;
import org.crsh.jcr.command.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRCommand
extends CRaSHCommand
implements Completer {
    protected JCRCommand() throws IntrospectionException {
    }

    public ValueCompletion complete(ParameterDescriptor<?> parameter, String prefix) throws Exception {
        if (parameter.getJavaValueType() == Path.class) {
            final Path path = (Path)((Object)this.getProperty("currentPath"));
            final Session session = (Session)this.getProperty("session");
            if (session != null) {
                AbstractPathCompleter<Node> pc = new AbstractPathCompleter<Node>(){

                    protected String getCurrentPath() throws Exception {
                        return path != null ? path.getString() : "/";
                    }

                    protected Node getPath(String path2) throws Exception {
                        try {
                            return (Node)session.getItem(path2);
                        }
                        catch (PathNotFoundException e) {
                            return null;
                        }
                    }

                    protected boolean exists(Node path2) throws Exception {
                        return path2 != null;
                    }

                    protected boolean isDirectory(Node path2) throws Exception {
                        return true;
                    }

                    protected boolean isFile(Node path2) throws Exception {
                        return false;
                    }

                    protected Collection<Node> getChilren(Node path2) throws Exception {
                        ArrayList<Node> children = new ArrayList<Node>();
                        NodeIterator i = path2.getNodes();
                        while (i.hasNext()) {
                            Node child = i.nextNode();
                            children.add(child);
                        }
                        return children;
                    }

                    protected String getName(Node path2) throws Exception {
                        return path2.getName();
                    }
                };
                return pc.complete(parameter, prefix);
            }
        }
        return ValueCompletion.create();
    }
}

