/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.util.Iterator;
import javax.jcr.Node;
import org.crsh.jcr.AbstractJCRCommandTestCase;

public class MoveTestCase
extends AbstractJCRCommandTestCase {
    public void testRelativeToRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv foo bar");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('bar')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
    }

    public void testMoveToExisting() {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv foo bar");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('bar[2]')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
    }

    public void testSubRelativeToSubRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.getNode('foo').addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv foo/bar foo/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('zed')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('bar')")));
    }

    public void testAbsoluteToAbsolute() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.getNode('foo').addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        Iterator produced = this.assertOk("mv /foo/bar /zed").getProduced().iterator();
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)produced.hasNext());
        MoveTestCase.assertEquals((String)"/zed", (String)((Node)produced.next()).getPath());
        MoveTestCase.assertFalse((boolean)produced.hasNext());
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('zed')")));
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('bar')")));
    }

    public void testRelativeToSubRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv foo bar/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('bar').hasNode('zed')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
    }

    public void testAbsoluteToRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv /foo bar/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('bar').hasNode('zed')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
    }

    public void testRelativeToAbsolute() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv foo /bar/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('bar').hasNode('zed')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
    }

    public void testSubRelativeToAbsolute() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.getNode('foo').addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("mv foo/bar /zed");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('zed')")));
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('bar')")));
    }

    public void testConsume() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.rootNode.addNode('juu');");
        this.groovyShell.evaluate("session.save();");
        Iterator produced = this.assertOk("produce foo bar | mv juu").getProduced().iterator();
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)produced.hasNext());
        MoveTestCase.assertEquals((String)"/juu/foo", (String)((Node)produced.next()).getPath());
        MoveTestCase.assertTrue((boolean)produced.hasNext());
        MoveTestCase.assertEquals((String)"/juu/bar", (String)((Node)produced.next()).getPath());
        MoveTestCase.assertFalse((boolean)produced.hasNext());
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('juu/foo')")));
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('juu/bar')")));
    }

    public void testNonTrivialRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo').addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cd foo ");
        this.assertOk("mv bar juu");
        this.groovyShell.evaluate("session.refresh(true);");
        MoveTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('juu')")));
        MoveTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('bar')")));
    }
}

