/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.IOException;
import org.crsh.jcr.FileSystem;
import org.crsh.jcr.SCPCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FileSystemAction {
    private static final Logger log = LoggerFactory.getLogger(FileSystemAction.class);

    FileSystemAction() {
    }

    public static void read(SCPCommand cmd, FileSystem fs) throws IOException {
        cmd.ack();
        log.debug("Want to read line");
        String line = cmd.readLine();
        log.debug("Read line " + line);
        FileSystemAction action = FileSystemAction.decode(line);
        log.debug("Action: " + action);
        FileSystemAction.read(cmd, action, fs);
    }

    private static void read(SCPCommand cmd, FileSystemAction action, FileSystem fs) throws IOException {
        if (action instanceof StartDirectory) {
            String directoryName = ((StartDirectory)action).name;
            fs.startDirectory(directoryName);
            cmd.ack();
            while (true) {
                String nextLine = cmd.readLine();
                FileSystemAction nextAction = FileSystemAction.decode(nextLine);
                log.debug("Next action: " + nextAction);
                if (nextAction instanceof EndDirectory) break;
                FileSystemAction.read(cmd, nextAction, fs);
            }
            fs.endDirectory(directoryName);
            cmd.ack();
        } else if (action instanceof File) {
            File file = (File)action;
            cmd.ack();
            fs.file(file.name, file.length, cmd.read(file.length));
            log.debug("About to send ack for file");
            cmd.ack();
            cmd.readAck();
        }
    }

    private static FileSystemAction decode(String line) {
        if (line == null) {
            throw new NullPointerException();
        }
        if (line.length() == 0) {
            throw new IllegalArgumentException("Line has length zero");
        }
        char t = line.charAt(0);
        if (t == 'C' || t == 'D') {
            int length;
            int endLength = line.indexOf(32, 6);
            if (endLength == -1) {
                throw new IllegalArgumentException();
            }
            String s = line.substring(6, endLength);
            if (s.length() == 1 && s.charAt(0) == '0') {
                length = 0;
            } else {
                try {
                    length = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse file length " + s);
                }
            }
            String name = line.substring(endLength + 1);
            if (t == 'D') {
                return new StartDirectory(name);
            }
            return new File(name, length);
        }
        if (t == 'E') {
            return new EndDirectory();
        }
        throw new IllegalArgumentException("Could not recognize file system action " + line);
    }

    private static class EndDirectory
    extends FileSystemAction {
        private EndDirectory() {
        }

        public String toString() {
            return "EndDirectory[]";
        }
    }

    private static class File
    extends FileSystemAction {
        private final String name;
        private final int length;

        private File(String name, int length) {
            this.name = name;
            this.length = length;
        }

        public String toString() {
            return "File[name=" + this.name + ",length=" + this.length + "]";
        }
    }

    private static class StartDirectory
    extends FileSystemAction {
        private final String name;

        private StartDirectory(String name) {
            this.name = name;
        }

        public String toString() {
            return "StartDirectory[name=" + this.name + "]";
        }
    }
}

