/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.crsh.jcr.AddMixinTestCase;
import org.crsh.jcr.AddNodeTestCase;
import org.crsh.jcr.CdTestCase;
import org.crsh.jcr.CopyTestCase;
import org.crsh.jcr.MoveTestCase;
import org.crsh.jcr.RemoveTestCase;
import org.crsh.jcr.RepositoryProvider;
import org.crsh.jcr.SelectTestCase;
import org.crsh.jcr.SetTestCase;
import org.crsh.jcr.ShellTestCase;
import org.crsh.jcr.WorkspaceTestCase;
import org.crsh.jcr.groovy.NodeMetaClassTestCase;
import org.crsh.shell.AbstractCommandTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJCRCommandTestCase
extends AbstractCommandTestCase {
    public static TestSuite createTestSuite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(AddMixinTestCase.class));
        suite.addTest((Test)new TestSuite(AddNodeTestCase.class));
        suite.addTest((Test)new TestSuite(CdTestCase.class));
        suite.addTest((Test)new TestSuite(CopyTestCase.class));
        suite.addTest((Test)new TestSuite(MoveTestCase.class));
        suite.addTest((Test)new TestSuite(RemoveTestCase.class));
        suite.addTest((Test)new TestSuite(SelectTestCase.class));
        suite.addTest((Test)new TestSuite(SetTestCase.class));
        suite.addTest((Test)new TestSuite(ShellTestCase.class));
        suite.addTest((Test)new TestSuite(WorkspaceTestCase.class));
        suite.addTest((Test)new TestSuite(NodeMetaClassTestCase.class));
        return suite;
    }

    public AbstractJCRCommandTestCase() {
    }

    public AbstractJCRCommandTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        RepositoryProvider.getProvider().getRepository();
        super.setUp();
        this.cleanRoot();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            RepositoryProvider.getProvider().logout();
        }
        super.tearDown();
    }

    private void cleanRoot() throws Exception {
        this.assertLogin();
        Node root = (Node)this.groovyShell.evaluate("session.rootNode");
        root.refresh(false);
        NodeIterator it = root.getNodes();
        while (it.hasNext()) {
            Node n = it.nextNode();
            if (n.getName().equals("jcr:system")) continue;
            this.log.log(Level.FINE, "Removed node " + n.getPath());
            n.remove();
        }
        root.getSession().save();
        this.evaluate("ws logout");
    }

    protected final void assertLogin() {
        try {
            String login = RepositoryProvider.getProvider().getLogin();
            this.assertOk(login);
        }
        catch (Exception e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
        this.assertOk("ws login -u exo -p exo ws");
    }

    protected final List<String> getStringValues(Property p) throws RepositoryException {
        ArrayList<String> strings = new ArrayList<String>();
        for (Value value : p.getValues()) {
            strings.add(value.getString());
        }
        return strings;
    }
}

