/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.ServiceLoader;
import javax.jcr.Node;
import javax.jcr.Repository;
import org.crsh.jcr.groovy.NodeMetaClass;
import org.crsh.plugin.CRaSHPlugin;

public abstract class JCRPlugin<T extends JCRPlugin>
extends CRaSHPlugin<T> {
    private static final Collection<String> NODES = Arrays.asList("org.exoplatform.services.jcr.impl.core.NodeImpl", "org.apache.jackrabbit.core.NodeImpl", "org.apache.jackrabbit.rmi.client.ClientNode", "org.apache.jackrabbit.rmi.server.ServerNode");
    private static final Object LOCK = new Object();
    private static boolean integrated = false;

    public static Repository findRepository(Map<String, String> properties) throws Exception {
        for (JCRPlugin plugin : ServiceLoader.load(JCRPlugin.class)) {
            Repository repository = plugin.getRepository(properties);
            if (repository == null) continue;
            return repository;
        }
        return null;
    }

    public static Iterable<JCRPlugin> findRepositories() throws Exception {
        return ServiceLoader.load(JCRPlugin.class);
    }

    public Collection<String> getNodeClassNames() {
        return NODES;
    }

    public abstract Repository getRepository(Map<String, String> var1) throws Exception;

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract String getUsage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        NodeMetaClass.setup();
        Object object = LOCK;
        synchronized (object) {
            if (!integrated) {
                try {
                    MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
                    Collection<Class<Node>> nodes = this.loadAvailablesNodeImplementations(this.getNodeClassNames());
                    for (Class<Node> nodeClass : nodes) {
                        this.registerNodeImplementation(registry, nodeClass);
                    }
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            }
            integrated = true;
        }
    }

    private Collection<Class<? extends Node>> loadAvailablesNodeImplementations(Collection<String> classNames) {
        ArrayList<Class<? extends Node>> classes = new ArrayList<Class<? extends Node>>(classNames.size());
        for (String className : classNames) {
            Class<Node> nodeClass = this.loadNodeImplementation(className);
            if (nodeClass == null) continue;
            classes.add(nodeClass);
        }
        return classes;
    }

    private Class<? extends Node> loadNodeImplementation(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void registerNodeImplementation(MetaClassRegistry registry, Class<? extends Node> nodeClass) throws IntrospectionException {
        NodeMetaClass mc2 = new NodeMetaClass(registry, nodeClass);
        mc2.initialize();
        registry.setMetaClass(nodeClass, (MetaClass)mc2);
    }
}

