/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PropertyType {
    PATH(8){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getString();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof String) {
                return node.setProperty(name, (String)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Collections.emptySet();
        }
    }
    ,
    STRING(1){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getString();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof String) {
                return node.setProperty(name, (String)value);
            }
            if (value instanceof Character) {
                return node.setProperty(name, Character.toString(((Character)value).charValue()));
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(String.class, Character.class);
        }
    }
    ,
    LONG(3){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getLong();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof Long) {
                return node.setProperty(name, ((Long)value).longValue());
            }
            if (value instanceof Integer) {
                return node.setProperty(name, (long)((Integer)value).intValue());
            }
            if (value instanceof Byte) {
                return node.setProperty(name, (long)((Byte)value).byteValue());
            }
            if (value instanceof BigInteger) {
                BigInteger biValue = (BigInteger)value;
                return node.setProperty(name, biValue.longValue());
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Long.class, Integer.class, Byte.class, BigInteger.class);
        }
    }
    ,
    DOUBLE(4){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getDouble();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof Double) {
                return node.setProperty(name, ((Double)value).doubleValue());
            }
            if (value instanceof Float) {
                return node.setProperty(name, (double)((Float)value).floatValue());
            }
            if (value instanceof BigDecimal) {
                BigDecimal bdValue = (BigDecimal)value;
                return node.setProperty(name, bdValue.doubleValue());
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Double.class, Float.class, BigDecimal.class);
        }
    }
    ,
    BOOLEAN(6){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getBoolean();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof Boolean) {
                return node.setProperty(name, ((Boolean)value).booleanValue());
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Boolean.class);
        }
    }
    ,
    DATE(5){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getDate();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof Calendar) {
                return node.setProperty(name, (Calendar)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Calendar.class);
        }
    }
    ,
    BINARY(2){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getStream();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof InputStream) {
                return node.setProperty(name, (InputStream)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(InputStream.class);
        }
    }
    ,
    REFERENCE(9){

        @Override
        public Object getValue(Property property) throws RepositoryException {
            return property.getNode();
        }

        @Override
        public Property set(Node node, String name, Object value) throws RepositoryException {
            if (value instanceof Node) {
                return node.setProperty(name, (Node)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Node.class);
        }
    };

    private static final PropertyType[] all;
    private static final Map<Class<?>, PropertyType> canonicalMapping;
    private final int value;

    public static PropertyType fromCanonicalType(Class<?> canonicalType) {
        for (Class<?> currentType = canonicalType; currentType != null; currentType = currentType.getSuperclass()) {
            PropertyType type = canonicalMapping.get(currentType);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static PropertyType fromValue(int v) {
        PropertyType type = null;
        if (v >= 0 && v < all.length) {
            type = all[v];
        }
        if (type == null) {
            throw new IllegalArgumentException("JCR Property type " + v + " not handled yet");
        }
        return type;
    }

    private PropertyType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public abstract Object getValue(Property var1) throws RepositoryException;

    public abstract Property set(Node var1, String var2, Object var3) throws RepositoryException;

    protected abstract Collection<Class<?>> getCanonicalTypes();

    static {
        all = new PropertyType[20];
        canonicalMapping = new HashMap();
        PropertyType[] arr$ = PropertyType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PropertyType type;
            PropertyType.all[type.value] = type = arr$[i$];
            for (Class<?> canonicalType : type.getCanonicalTypes()) {
                canonicalMapping.put(canonicalType, type);
            }
        }
    }
}

