/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugins.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.ClientResourceLocator;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.service.client.ResourceLocator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;

public class CrowdAuthenticationPlugin
extends CRaSHPlugin<AuthenticationPlugin>
implements AuthenticationPlugin {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static volatile CrowdClient crowdClient;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CrowdClient getCrowdClient() {
        if (crowdClient == null) {
            Object object = lock;
            synchronized (object) {
                if (crowdClient == null) {
                    ClientResourceLocator crl = new ClientResourceLocator("crowd.properties");
                    if (crl.getProperties() == null) {
                        throw new NullPointerException("crowd.properties can not be found in classpath");
                    }
                    ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)crl);
                    RestCrowdClientFactory restCrowdClientFactory = new RestCrowdClientFactory();
                    crowdClient = restCrowdClientFactory.newInstance((ClientProperties)clientProperties);
                }
            }
        }
        return crowdClient;
    }

    public String getName() {
        return "crowd";
    }

    public boolean authenticate(String username, String password) throws Exception {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            this.log.log(Level.WARNING, "Unable to logon without username and password.");
            return false;
        }
        try {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Authenticating '" + username + "' on crowd directory");
            }
            CrowdAuthenticationPlugin.getCrowdClient().authenticateUser(username, password);
            return true;
        }
        catch (InvalidAuthenticationException e) {
            this.log.log(Level.WARNING, "Authentication failed for user '" + username + "'");
            return false;
        }
        catch (ApplicationPermissionException e) {
            this.log.log(Level.SEVERE, "Application not authorized to authenticate user '" + username + "'", e);
            return false;
        }
    }

    public AuthenticationPlugin getImplementation() {
        return this;
    }

    static {
        lock = new Object();
    }
}

