/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.mail;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.mail.MessagingException;
import junit.framework.Assert;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcessContext;
import org.crsh.TestPluginLifeCycle;
import org.crsh.mail.Support;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSHSession;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class MailCommandTestCase
extends AbstractTestCase {
    public void testFoo() throws Exception {
        Support support = new Support(){

            @Override
            protected void execute(TestPluginLifeCycle lifeCycle, Wiser wiser) throws IOException, MessagingException, ExecutionException, InterruptedException {
                CRaSHSession shell = lifeCycle.createShell();
                BaseProcessContext process = BaseProcessContext.create((Shell)shell, (String)"echo abc | mail -s the_subject -b admin@gmail.com").execute();
                ShellResponse.Ok ok = (ShellResponse.Ok)AbstractTestCase.assertInstance(ShellResponse.Ok.class, (Object)process.getResponse());
                Assert.assertEquals((int)1, (int)wiser.getMessages().size());
                WiserMessage msg = (WiserMessage)wiser.getMessages().get(0);
                Assert.assertEquals((String)"admin@gmail.com", (String)msg.getEnvelopeReceiver());
                Assert.assertEquals((String)"the_subject", (String)msg.getMimeMessage().getSubject());
                String data = new String(msg.getData());
                Assert.assertTrue((boolean)data.contains("Content-Type: text/html;charset=UTF-8"));
            }
        };
        support.doTest();
    }
}

