/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.crsh.shell.Resource;
import org.crsh.shell.ResourceKind;
import org.crsh.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestShellContext
implements ShellContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<String> scriptPaths;

    public TestShellContext(String ... scriptPaths) {
        this.scriptPaths = new ArrayList<String>(Arrays.asList(scriptPaths));
    }

    public String getVersion() {
        return "1.0.0";
    }

    public Resource loadResource(String resourceId, ResourceKind resourceKind) {
        if (resourceId == null) {
            throw new NullPointerException("No null resource id");
        }
        if (resourceKind == null) {
            throw new NullPointerException("No null resource kind");
        }
        Resource res = null;
        switch (resourceKind) {
            case LIFECYCLE: {
                if (!"login".equals(resourceId) && !"logout".equals(resourceId)) break;
                StringBuilder sb = new StringBuilder();
                long timestamp = Long.MIN_VALUE;
                for (String path : this.scriptPaths) {
                    Resource url = this.getResource(path + resourceId + ".groovy");
                    if (url == null) continue;
                    sb.append(url.getContent());
                    timestamp = Math.max(timestamp, url.getTimestamp());
                }
                res = new Resource(sb.toString(), timestamp);
                break;
            }
            case SCRIPT: {
                String scriptPath;
                Iterator<String> i$ = this.scriptPaths.iterator();
                while (i$.hasNext() && (res = this.getResource((scriptPath = i$.next()) + resourceId + ".groovy")) == null) {
                }
                break;
            }
            case CONFIG: {
                if ("telnet.properties".equals(resourceId)) {
                    res = this.getResource("telnet/telnet.properties");
                    break;
                }
                resourceId = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return res;
    }

    public List<String> listResourceId(ResourceKind kind) {
        throw new UnsupportedOperationException();
    }

    private Resource getResource(String path) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url != null) {
            return Resource.create((URL)url);
        }
        return null;
    }

    public ClassLoader getLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

