/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.console;

import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.console.ClientOutput;
import org.crsh.console.Console;
import org.crsh.console.TestClientOutput;

public abstract class AbstractConsoleTestCase
extends TestCase {
    protected abstract boolean getSupportsCursorMove();

    private static void assertEquals(CharSequence expected, CharSequence actual) {
        AbstractConsoleTestCase.assertEquals((String)((Object)expected).toString(), (String)((Object)actual).toString());
    }

    private Console newConsole() {
        return new Console((ClientOutput)new TestClientOutput(this.getSupportsCursorMove()));
    }

    public void testWriterCRLF() throws IOException {
        Console console;
        TestClientOutput output;
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            output = new TestClientOutput(this.getSupportsCursorMove());
            console = new Console((ClientOutput)output);
            console.getWriter().write((CharSequence)test);
            output.assertChars("a\r\n");
            output.assertEmpty();
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            output = new TestClientOutput(this.getSupportsCursorMove());
            console = new Console((ClientOutput)output);
            console.getWriter().write((CharSequence)test);
            output.assertChars("a\r\n\r\n");
            output.assertEmpty();
        }
    }

    public void testNoCR() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"a");
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals((int)1, (int)console.getReader().getSize());
    }

    public void testReadLine() throws IOException {
        Console console;
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            console = this.newConsole();
            console.getClientInput().write((CharSequence)test);
            AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals("a", console.getReader().next());
            AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals((int)0, (int)console.getReader().getSize());
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            console = this.newConsole();
            console.getClientInput().write((CharSequence)test);
            AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals("a", console.getReader().next());
            AbstractConsoleTestCase.assertEquals("", console.getReader().next());
            AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals((int)0, (int)console.getReader().getSize());
        }
    }

    public void testErase() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"a");
        console.getClientInput().del();
        console.getClientInput().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals("b", console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    public void testMoveLeftInsert() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"a");
        console.getClientInput().moveLeft();
        console.getClientInput().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftInsert(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftInsert();

    public void testMoveLeftDel() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"ab");
        console.getClientInput().moveLeft();
        console.getClientInput().del();
        console.getClientInput().write((CharSequence)"\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftDel(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftDel();

    public void testMoveRightInsert() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"abc");
        console.getClientInput().moveLeft();
        console.getClientInput().moveLeft();
        console.getClientInput().moveRight();
        console.getClientInput().write((CharSequence)"d\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightInsert(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightInsert();

    public void testMoveRightDel() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"abc");
        console.getClientInput().moveLeft();
        console.getClientInput().moveLeft();
        console.getClientInput().moveRight();
        console.getClientInput().del();
        console.getClientInput().write((CharSequence)"\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightDel(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightDel();

    public void testMoveRightAtEndOfLine() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"a");
        console.getClientInput().moveRight();
        console.getClientInput().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightAtEndOfLine(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightAtEndOfLine();

    public void testMoveLeftAtBeginningOfLine() throws IOException {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"a");
        console.getClientInput().moveLeft();
        console.getClientInput().moveLeft();
        console.getClientInput().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftAtBeginningOfLine(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftAtBeginningOfLine();

    public void testClearBuffer() throws Exception {
        Console console = this.newConsole();
        console.getClientInput().write((CharSequence)"a");
        console.clearBuffer();
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
        console.getClientInput().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertEquals("b", console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }
}

