/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.util.Arrays;
import junit.framework.TestCase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.command.ClassCommand;
import org.crsh.command.ShellCommand;
import org.crsh.shell.TestCommandContext;
import org.crsh.shell.impl.GroovyScriptCommand;

public class ShellCommandTestCase
extends TestCase {
    private GroovyClassLoader loader;
    private GroovyShell shell;

    protected void setUp() throws Exception {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(GroovyScriptCommand.class.getName());
        this.loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        this.shell = new GroovyShell((ClassLoader)this.loader);
    }

    public void testOptionInjectionInCommandClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { @org.kohsuke.args4j.Option(name=\"-str\") def String str = 'default value';public Object execute() {return str;}}");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"abc", (String)new TestCommandContext().execute(cmd, new String[]{"-str", "abc"}));
    }

    public void testArgumentInjectionInCommandClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { @org.kohsuke.args4j.Argument def String str = 'default value';public Object execute() {return str;}}");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"b", (String)new TestCommandContext().execute(cmd, new String[]{"b"}));
    }

    public void testContextAccessInCommandClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { public Object execute() {return bar;}}");
        TestCommandContext ctx = new TestCommandContext();
        ctx.getAttributes().put("bar", "bar_value");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"bar_value", (String)ctx.execute(cmd, new String[0]));
    }

    public void testClosureInvocationInClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand { public Object execute() {return bar();}}");
        TestCommandContext ctx = new TestCommandContext();
        Closure closure = (Closure)this.shell.evaluate("{ -> return 'from_closure'; }");
        ctx.getAttributes().put("bar", closure);
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"from_closure", (String)ctx.execute(cmd, new String[0]));
    }

    public void testArgumentQuoteInClass() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand {\n@org.kohsuke.args4j.Argument\ndef List<String> arguments;\npublic Object execute() {\nreturn arguments;\n}\n}\n");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)("" + Arrays.asList("foo")), (String)new TestCommandContext().execute(cmd, new String[]{"'foo'"}));
    }

    public void testArgumentQuoteInClass2() throws Exception {
        Class clazz = this.loader.parseClass("class foo extends org.crsh.command.ClassCommand {\n@org.kohsuke.args4j.Argument\ndef List<String> arguments;\n{ unquoteArguments = false; }\npublic Object execute() {\nreturn arguments;\n}\n}\n");
        ClassCommand cmd = (ClassCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)("" + Arrays.asList("'foo'")), (String)new TestCommandContext().execute(cmd, new String[]{"'foo'"}));
    }

    public void testContextAccessInScript() throws Exception {
        Class clazz = this.loader.parseClass("System.out.println('bar:' + bar) ; return bar;");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        TestCommandContext ctx = new TestCommandContext();
        ctx.getAttributes().put("bar", "bar_value");
        ShellCommandTestCase.assertEquals((String)"bar_value", (String)ctx.execute(script, new String[0]));
    }

    public void testArgumentAccessInScript() throws Exception {
        Class clazz = this.loader.parseClass("return args[0];");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"arg_value", (String)new TestCommandContext().execute(script, "arg_value"));
    }

    public void testArgumentAccessInClosure() throws Exception {
        Class clazz = this.loader.parseClass("{ arg -> return arg };");
        ShellCommand script = (ShellCommand)clazz.newInstance();
        ShellCommandTestCase.assertEquals((String)"arg_value", (String)new TestCommandContext().execute(script, "arg_value"));
    }
}

