/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.crsh.command.ScriptException;
import org.crsh.shell.impl.Token;
import org.crsh.shell.impl.Tokenizer;

public class TokenizerTestCase
extends TestCase {
    public void testEmpty() {
        new TestTokenizer("").assertEOF();
        new TestTokenizer(" ").assertEOF();
    }

    public void testCommand() {
        new TestTokenizer("a").assertCommand("a");
        new TestTokenizer("' '").assertCommand("' '");
        new TestTokenizer("\" \"").assertCommand("\" \"");
        new TestTokenizer("'\"'").assertCommand("'\"'");
        new TestTokenizer("\"'\"").assertCommand("\"'\"");
        new TestTokenizer(" ' ' ").assertCommand("' '");
        new TestTokenizer("'+'").assertCommand("'+'");
        new TestTokenizer("'|'").assertCommand("'|'");
        new TestTokenizer("\"+\"").assertCommand("\"+\"");
        new TestTokenizer("\"|\"").assertCommand("\"|\"");
        new TestTokenizer("\"").assertFail();
        new TestTokenizer("'").assertFail();
        new TestTokenizer("a b").assertCommand("a", "b");
    }

    public void testPlus() {
        new TestTokenizer("+").assertPlus();
    }

    public void testPipe() {
        new TestTokenizer("|").assertPipe();
    }

    public void testComposite() {
        TestTokenizer tokenizer = new TestTokenizer("a | b c + d");
        tokenizer.assertCommand("a");
        tokenizer.assertPipe();
        tokenizer.assertCommand("b", "c");
        tokenizer.assertPlus();
        tokenizer.assertCommand("d");
    }

    private static class TestTokenizer
    extends Tokenizer {
        private TestTokenizer(CharSequence s) throws NullPointerException {
            super(s);
        }

        public void assertPipe() {
            Assert.assertEquals((Object)Token.PIPE, (Object)this.nextToken());
        }

        public void assertPlus() {
            Assert.assertEquals((Object)Token.PLUS, (Object)this.nextToken());
        }

        public void assertEOF() {
            Assert.assertEquals((Object)Token.EOF, (Object)this.nextToken());
        }

        public void assertCommand(String ... chunks) {
            Token.Command c = (Token.Command)this.nextToken();
            Assert.assertEquals(Arrays.asList(chunks), (Object)c.chunks);
        }

        public void assertFail() {
            try {
                this.nextToken();
                Assert.fail();
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
        }
    }
}

