/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.term.BaseTerm;
import org.crsh.term.TermAction;
import org.crsh.term.processor.TermProcessor;
import org.crsh.term.processor.TermResponseContext;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TestTermConnector;

public class BaseTermTestCase
extends TestCase {
    private static final TermProcessor ECHO_PROCESSOR = new TermProcessor(){

        public boolean process(TermAction action, TermResponseContext responseContext) {
            if (action instanceof TermAction.Init) {
                responseContext.done(false);
                return true;
            }
            if (action instanceof TermAction.ReadLine) {
                String line = ((Object)((TermAction.ReadLine)action).getLine()).toString();
                if ("bye".equals(line)) {
                    responseContext.done(true);
                    return true;
                }
                try {
                    responseContext.write(line);
                    responseContext.done(false);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (action instanceof TermAction.CancelEvaluation) {
                responseContext.done(false);
                return true;
            }
            responseContext.done(true);
            return true;
        }
    };

    public void testLine() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("abc\r\n");
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testDel() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendDel();
        controller.connector.append("\r\n");
        controller.connector.assertChars("abc");
        controller.connector.assertDel();
        controller.connector.assertCRLF();
        controller.connector.assertChars("ab");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testBreak() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendBreak();
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.append("def\r\n");
        controller.connector.assertChars("def");
        controller.connector.assertCRLF();
        controller.connector.assertChars("def");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testInsert() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendMoveLeft();
        controller.connector.append("c\r\n");
        controller.connector.assertChars("ab");
        controller.connector.assertMoveLeft();
        controller.connector.assertChars("cb");
        controller.connector.assertMoveLeft();
        controller.connector.assertCRLF();
        controller.connector.assertChars("acb");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveRight() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.appendMoveRight();
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveLeft() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.appendMoveLeft();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testMoveUp() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a");
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveUp() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveUp();
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a");
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveDown() throws Exception {
        Controller controller = this.create(ECHO_PROCESSOR);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveDown();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    private Controller create(TermProcessor processor) throws IOException {
        return new Controller(new TestTermConnector(), processor);
    }

    private class Controller
    extends BaseTerm {
        private volatile boolean running;
        private final CountDownLatch startSync;
        private final CountDownLatch stopSync;
        private final Thread thread;
        private final TestTermConnector connector;

        private Controller(TestTermConnector connector, TermProcessor processor) {
            super((TermIO)connector, processor);
            this.running = true;
            this.startSync = new CountDownLatch(1);
            this.stopSync = new CountDownLatch(1);
            this.thread = new Thread((Runnable)((Object)this));
            this.connector = connector;
        }

        public void assertStart() {
            this.thread.start();
            try {
                Assert.assertTrue((boolean)this.startSync.await(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
            Assert.assertTrue((boolean)this.running);
            this.connector.assertCRLF();
            this.connector.assertChars("% ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            this.startSync.countDown();
            try {
                super.run();
            }
            finally {
                this.running = false;
                this.stopSync.countDown();
            }
        }

        public void assertStop() {
            Assert.assertTrue((boolean)this.running);
            this.connector.append("bye\r\n");
            this.connector.assertChars("bye");
            this.connector.assertCRLF();
            try {
                Assert.assertTrue((boolean)this.stopSync.await(4L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
            Assert.assertFalse((boolean)this.running);
        }
    }
}

