/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.crsh.TestShell;
import org.crsh.TestShellContext;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellContext;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.connector.Connector;
import org.crsh.shell.connector.ConnectorResponseContext;
import org.crsh.shell.connector.ConnectorStatus;

public class ConnectorTestCase
extends TestCase {
    protected ShellFactory builder;
    protected TestShellContext context;
    protected ExecutorService executor;
    private static volatile int status;

    protected void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newSingleThreadExecutor();
        this.context = new TestShellContext("groovy/commands/base/", "groovy/commands/jcr/", "groovy/commands/test/");
        this.builder = new ShellFactory((ShellContext)this.context);
    }

    public void testReadLine() throws Exception {
        final LinkedList output = new LinkedList();
        final LinkedList<String> input = new LinkedList<String>();
        input.add("juu");
        TestShell shell = new TestShell(){

            public ShellResponse evaluate(String request, ShellResponseContext responseContext) {
                String a = responseContext.readLine("bar", true);
                return new ShellResponse.Display(a);
            }
        };
        Connector connector = new Connector(this.executor, (Shell)shell);
        connector.open();
        ShellResponse actual = (ShellResponse)connector.submitEvaluation("foo", new ConnectorResponseContext(){

            public void completed(String s) {
            }

            public String readLine(String s, boolean echo) {
                output.addLast(s);
                return input.isEmpty() ? null : (String)input.removeLast();
            }

            public void done(boolean close) {
            }

            public void setPrompt(String prompt) {
            }
        }).get();
        ConnectorTestCase.assertTrue((boolean)(actual instanceof ShellResponse.Display));
        ConnectorTestCase.assertEquals((String)"juu", (String)actual.getText());
        ConnectorTestCase.assertEquals(Collections.singletonList("bar"), output);
        ConnectorTestCase.assertEquals((int)0, (int)input.size());
    }

    public void testCancelEvaluation() {
        ShellResponse.Ok ok = new ShellResponse.Ok();
        final AtomicBoolean fail = new AtomicBoolean(false);
        final AtomicInteger status = new AtomicInteger(0);
        TestShell shell = new TestShell((ShellResponse)ok){
            final /* synthetic */ ShellResponse val$ok;
            {
                this.val$ok = shellResponse;
            }

            public ShellResponse evaluate(String request, ShellResponseContext responseContext) {
                fail.set(!"foo".equals(request));
                if (status.get() == 0) {
                    status.set(1);
                    int r = status.get();
                    while (r == 1) {
                        r = status.get();
                    }
                    if (r == 2) {
                        status.set(3);
                    } else {
                        status.set(-1);
                    }
                } else {
                    status.set(-1);
                }
                return this.val$ok;
            }
        };
        Connector connector = new Connector(this.executor, (Shell)shell);
        connector.open();
        connector.submitEvaluation("foo");
        ConnectorTestCase.assertEquals((Object)ConnectorStatus.EVALUATING, (Object)connector.getStatus());
        int r = status.get();
        while (r == 0) {
            r = status.get();
        }
        ConnectorTestCase.assertEquals((int)1, (int)r);
        ConnectorTestCase.assertEquals((Object)ConnectorStatus.EVALUATING, (Object)connector.getStatus());
        connector.cancelEvalutation();
        ConnectorTestCase.assertEquals((Object)ConnectorStatus.AVAILABLE, (Object)connector.getStatus());
        status.set(2);
        r = status.get();
        while (r == 2) {
            r = status.get();
        }
        ConnectorTestCase.assertEquals((int)3, (int)r);
        ConnectorTestCase.assertFalse((boolean)fail.get());
    }

    public void testAsyncEvaluation() {
        Connector connector = new Connector(this.executor, (Shell)this.builder.build());
        connector.open();
        status = 0;
        connector.submitEvaluation("invoke " + ConnectorTestCase.class.getName() + " bilto");
        while (status == 0) {
        }
        ConnectorTestCase.assertEquals((int)1, (int)status);
        connector.popResponse();
    }

    public static void bilto() {
        status = status == 0 ? 1 : -1;
    }
}

