/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.crsh.term.Term;
import org.crsh.term.TermAction;
import org.crsh.term.processor.TermProcessor;
import org.crsh.term.processor.TermResponseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTerm
implements Term {
    private StringBuilder writer;
    private boolean closed = false;
    private BlockingDeque<TermAction> actions;
    private final TermProcessor processor;
    private final Logger log = LoggerFactory.getLogger(TestTerm.class);
    private final Thread thread = new Thread(){

        public void run() {
            final AtomicBoolean wantClose = new AtomicBoolean(false);
            while (!TestTerm.this.closed) {
                try {
                    TermAction action = (TermAction)TestTerm.this.actions.takeFirst();
                    final AtomicBoolean done = new AtomicBoolean(false);
                    TermResponseContext ctx = new TermResponseContext(){

                        public void setEcho(boolean echo) {
                        }

                        public TermAction read() throws IOException {
                            return TestTerm.this.read();
                        }

                        public void write(String msg) throws IOException {
                            TestTerm.this.write(msg);
                        }

                        public void setPrompt(String prompt) {
                        }

                        public void done(boolean close) {
                            done.set(true);
                            if (close) {
                                wantClose.set(true);
                            }
                        }
                    };
                    boolean consumed = TestTerm.this.processor.process(action, ctx);
                    if (!consumed) {
                        TestTerm.this.actions.addFirst(action);
                        continue;
                    }
                    while (!done.get()) {
                    }
                }
                catch (Exception e) {
                    TestTerm.this.log.error("Action delivery failed", (Throwable)e);
                }
            }
            if (wantClose.get()) {
                TestTerm.this.close();
            }
        }
    };

    public TestTerm(TermProcessor processor) {
        this.writer = new StringBuilder();
        this.actions = new LinkedBlockingDeque<TermAction>();
        this.processor = processor;
        this.thread.start();
    }

    public String getOutput() {
        String s = this.writer.toString();
        this.writer.setLength(0);
        return s;
    }

    public void add(TermAction action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.actions.addLast(action);
    }

    public TermAction read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        try {
            return this.actions.takeFirst();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void write(String data) throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.writer.append(data);
    }

    public void close() {
        this.closed = true;
    }
}

