/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.crsh.shell.Resource;
import org.crsh.shell.ResourceKind;
import org.crsh.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletShellContext
implements ShellContext {
    private static final Logger log = LoggerFactory.getLogger(ServletShellContext.class);
    private final ServletContext servletContext;
    private final ClassLoader loader;
    private final String version;
    private ScheduledExecutorService executor;
    private volatile List<String> dirs;
    private final Pattern p = Pattern.compile(".*/(.+)\\.groovy");

    public ServletShellContext(ServletContext servletContext, ClassLoader loader) {
        if (servletContext == null) {
            throw new NullPointerException();
        }
        if (loader == null) {
            throw new NullPointerException();
        }
        String version = null;
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.crsh/crsh.shell.core/pom.properties");
            if (in != null) {
                props.load(in);
                version = props.getProperty("version");
            }
        }
        catch (Exception e) {
            log.error("Could not load maven properties", (Throwable)e);
        }
        if (version == null) {
            log.warn("No version found will use unknown value instead");
            version = "unknown";
        }
        this.servletContext = servletContext;
        this.loader = loader;
        this.version = version;
        this.dirs = Collections.emptyList();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Resource loadResource(String resourceId, ResourceKind resourceKind) {
        Resource res = null;
        try {
            switch (resourceKind) {
                case LIFECYCLE: {
                    if (!"login".equals(resourceId) && !"logout".equals(resourceId)) break;
                    StringBuilder sb = new StringBuilder();
                    long timestamp = Long.MIN_VALUE;
                    for (String path : this.dirs) {
                        Resource sub;
                        URL url = this.servletContext.getResource(path + resourceId + ".groovy");
                        if (url == null || (sub = Resource.create(url)) == null) continue;
                        sb.append(sub.getContent());
                        timestamp = Math.max(timestamp, sub.getTimestamp());
                    }
                    return new Resource(sb.toString(), timestamp);
                }
                case SCRIPT: {
                    for (String path : this.dirs) {
                        URL url = this.servletContext.getResource(path + resourceId + ".groovy");
                        if (url == null) continue;
                        return Resource.create(url);
                    }
                    break;
                }
                case CONFIG: {
                    URL url;
                    if (!"telnet.properties".equals(resourceId) || (url = this.servletContext.getResource("/WEB-INF/telnet/telnet.properties")) == null) break;
                    return Resource.create(url);
                }
            }
        }
        catch (IOException e) {
            log.warn("Could not obtain resource " + resourceId, (Throwable)e);
        }
        return res;
    }

    @Override
    public List<String> listResourceId(ResourceKind kind) {
        switch (kind) {
            case SCRIPT: {
                TreeSet<String> all = new TreeSet<String>();
                for (String path : this.dirs) {
                    Set files = this.servletContext.getResourcePaths(path);
                    for (String file : files) {
                        Matcher matcher = this.p.matcher(file);
                        if (!matcher.matches()) continue;
                        all.add(matcher.group(1));
                    }
                }
                all.remove("login");
                all.remove("logout");
                return new ArrayList<String>(all);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public ClassLoader getLoader() {
        return this.loader;
    }

    public synchronized void start() {
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){
                int count = 0;

                public void run() {
                    Set set = ServletShellContext.this.servletContext.getResourcePaths("/WEB-INF/groovy/commands/");
                    if (set != null) {
                        ArrayList<String> newDirs = new ArrayList<String>();
                        newDirs.add("/WEB-INF/groovy/commands/");
                        for (String path : set) {
                            if (!path.endsWith("/")) continue;
                            newDirs.add(path);
                        }
                        ServletShellContext.this.dirs = newDirs;
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        } else {
            log.warn("Attempt to double start");
        }
    }

    public synchronized void stop() {
        if (this.executor != null) {
            ScheduledExecutorService tmp = this.executor;
            this.executor = null;
            tmp.shutdown();
        } else {
            log.warn("Attempt to stop when stopped");
        }
    }
}

