/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.connector;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.connector.ConnectorResponseContext;
import org.crsh.shell.connector.ConnectorStatus;
import org.crsh.shell.connector.FutureEvaluation;
import org.crsh.shell.connector.ResponseEvaluation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector {
    private final Logger log = LoggerFactory.getLogger(Connector.class);
    private ConnectorStatus status;
    private FutureEvaluation futureEvaluation;
    private final Object lock;
    private final Shell shell;
    private final ExecutorService executor;

    public Connector(Shell shell) {
        this(null, shell);
    }

    public Connector(ExecutorService executor, Shell shell) {
        this.executor = executor;
        this.shell = shell;
        this.status = ConnectorStatus.INITIAL;
        this.lock = new Object();
    }

    public boolean isClosed() {
        return this.status == ConnectorStatus.CLOSED;
    }

    public String open() {
        if (this.status != ConnectorStatus.INITIAL) {
            throw new IllegalStateException();
        }
        String ret = this.shell.getWelcome();
        this.status = ConnectorStatus.AVAILABLE;
        return ret;
    }

    public String getPrompt() {
        try {
            return this.shell.getPrompt();
        }
        catch (Exception e) {
            this.log.error("Could not obtain prompt", (Throwable)e);
            return "% ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorStatus getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    public Future<ShellResponse> submitEvaluation(String request) {
        return this.submitEvaluation(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ShellResponse> submitEvaluation(final String request, final ConnectorResponseContext handler) {
        final ShellResponseContext responseContext = new ShellResponseContext(){

            public String readLine(String msg, boolean echo) {
                return handler.readLine(msg, echo);
            }
        };
        Object object = this.lock;
        synchronized (object) {
            Future<ShellResponse> clientResponse;
            if (this.status != ConnectorStatus.AVAILABLE) {
                throw new IllegalStateException("State was " + (Object)((Object)this.status));
            }
            Callable<ShellResponse> callable = "bye".equals(request) ? new Callable<ShellResponse>(){

                @Override
                public ShellResponse call() throws Exception {
                    return new ShellResponse.Close();
                }
            } : new Callable<ShellResponse>(){

                @Override
                public ShellResponse call() throws Exception {
                    return Connector.this.shell.evaluate(request, responseContext);
                }
            };
            ResponseEvaluation evaluation = new ResponseEvaluation(this, handler, callable);
            if (this.executor != null) {
                Future<ShellResponse> futureResponse = this.executor.submit(evaluation);
                this.futureEvaluation = new FutureEvaluation(futureResponse, handler);
                this.status = ConnectorStatus.EVALUATING;
                clientResponse = futureResponse;
            } else {
                try {
                    FutureTask<ShellResponse> futureResponse = new FutureTask<ShellResponse>(evaluation);
                    this.futureEvaluation = new FutureEvaluation(futureResponse, handler);
                    this.status = ConnectorStatus.EVALUATING;
                    futureResponse.run();
                    clientResponse = futureResponse;
                }
                catch (Exception e) {
                    AssertionError afe = new AssertionError((Object)"Should not happen");
                    ((Throwable)((Object)afe)).initCause(e);
                    throw afe;
                }
            }
            return clientResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelEvalutation() {
        FutureEvaluation evaluation = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.status == ConnectorStatus.EVALUATING) {
                evaluation = this.futureEvaluation;
                this.status = ConnectorStatus.AVAILABLE;
                this.futureEvaluation = null;
            }
        }
        if (evaluation != null) {
            evaluation.futureResponse.cancel(true);
            if (evaluation.responseHandler != null) {
                evaluation.responseHandler.done(false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(ConnectorResponseContext responseContext, ShellResponse response) {
        Object object = this.lock;
        synchronized (object) {
            String ret = null;
            switch (this.status) {
                case EVALUATING: {
                    try {
                        ret = response.getText();
                        this.futureEvaluation = null;
                        break;
                    }
                    finally {
                        this.status = ConnectorStatus.AVAILABLE;
                    }
                }
                case AVAILABLE: {
                    break;
                }
                case CLOSED: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"That should not be possible");
                }
            }
            if (responseContext != null) {
                if (ret != null) {
                    this.log.debug("Making handler response callback with " + ret);
                    responseContext.completed(ret);
                }
                String prompt = this.getPrompt();
                responseContext.setPrompt(prompt);
                this.log.debug("Signaling done to response context");
                responseContext.done(response instanceof ShellResponse.Close);
            }
        }
    }

    public String popResponse() {
        ShellResponse response = null;
        if (this.futureEvaluation != null) {
            try {
                response = this.futureEvaluation.futureResponse.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            return response.getText();
        }
        return null;
    }

    public String evaluate(String request) {
        this.submitEvaluation(request, null);
        return this.popResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case AVAILABLE: 
                case INITIAL: {
                    break;
                }
                case EVALUATING: {
                    throw new UnsupportedOperationException("todo :-)");
                }
            }
            this.status = ConnectorStatus.CLOSED;
        }
    }
}

