/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.io.ShellPrinter;
import org.crsh.util.LineFeedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandContextImpl<C, P>
implements CommandContext<C, P> {
    private final ShellResponseContext responseContext;
    private final Map<String, Object> attributes;
    private ShellPrinter writer;
    private StringWriter buffer;
    private List<P> products;
    private Iterable<C> consumedItems;

    public CommandContextImpl(ShellResponseContext responseContext, Iterable<C> consumedItems, Map<String, Object> attributes) {
        this.attributes = attributes;
        this.responseContext = responseContext;
        this.writer = null;
        this.buffer = null;
        this.consumedItems = consumedItems;
        this.products = Collections.emptyList();
    }

    public List<P> getProducedItems() {
        return this.products;
    }

    public StringWriter getBuffer() {
        return this.buffer;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isPiped() {
        return this.consumedItems != null;
    }

    @Override
    public Iterable<C> consume() {
        if (this.consumedItems == null) {
            throw new IllegalStateException("Cannot consume as no pipe operation is involved");
        }
        return this.consumedItems;
    }

    @Override
    public void produce(P product) {
        if (this.products.isEmpty()) {
            this.products = new LinkedList<P>();
        }
        this.products.add(product);
    }

    @Override
    public ShellPrinter getWriter() {
        if (this.writer == null) {
            this.buffer = new StringWriter();
            this.writer = new ShellPrinter(new LineFeedWriter(this.buffer, "\r\n"));
        }
        return this.writer;
    }

    @Override
    public String readLine(String msg, boolean echo) {
        if (this.responseContext != null) {
            return this.responseContext.readLine(msg, echo);
        }
        throw new IllegalStateException("The command does not have access to console line reading");
    }
}

