/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi.sshd.scp;

import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.crsh.plugin.PluginManager;
import org.crsh.term.spi.sshd.FailCommand;
import org.crsh.term.spi.sshd.scp.CommandPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCPCommandFactory
implements CommandFactory {
    private static final Logger log = LoggerFactory.getLogger(SCPCommandFactory.class);
    private final PluginManager<CommandPlugin> plugins;

    public SCPCommandFactory(PluginManager<CommandPlugin> plugins) {
        this.plugins = plugins;
    }

    public Command createCommand(String command) {
        command = command.trim();
        log.debug("About to execute shell command " + command);
        for (CommandPlugin plugin : this.plugins.getPlugins()) {
            Command cmd = plugin.createCommand(command);
            if (cmd == null) continue;
            return cmd;
        }
        return new FailCommand("Unrecognized command " + command);
    }
}

