/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi.telnet;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.net.Connection;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;

public class TelnetIO
implements TermIO {
    private final Connection conn;
    private final BasicTerminalIO termIO;

    public TelnetIO(Connection conn) {
        this.conn = conn;
        this.termIO = conn.getTerminalIO();
    }

    public int read() throws IOException {
        return this.termIO.read();
    }

    public CodeType decode(int code) {
        switch (code) {
            case 3: {
                return CodeType.BREAK;
            }
            case 1302: 
            case 1303: {
                return CodeType.DELETE;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
            case 1003: {
                return CodeType.RIGHT;
            }
            case 1004: {
                return CodeType.LEFT;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
        this.conn.close();
    }

    public void flush() throws IOException {
        this.termIO.flush();
    }

    public void write(String s) throws IOException {
        this.termIO.write(s);
    }

    public void write(char c) throws IOException {
        this.termIO.write(c);
    }

    public void writeDel() throws IOException {
        this.termIO.moveLeft(1);
        this.termIO.write(' ');
        this.termIO.moveLeft(1);
        this.termIO.flush();
    }

    public void writeCRLF() throws IOException {
        this.termIO.write("\r\n");
    }

    public boolean moveRight() throws IOException {
        this.termIO.moveRight(1);
        return true;
    }

    public boolean moveLeft() throws IOException {
        this.termIO.moveLeft(1);
        return true;
    }
}

