/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.Description;
import org.crsh.command.DescriptionMode;
import org.crsh.command.GroovyCommand;
import org.crsh.command.InvocationContext;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.util.Strings;
import org.crsh.util.TypeResolver;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCommand<C, P>
extends GroovyCommand
implements ShellCommand,
CommandInvoker<C, P> {
    private InvocationContext<C, P> context = null;
    private boolean unquoteArguments = true;
    private Class<C> consumedType = (Class)TypeResolver.resolve(this.getClass(), CommandInvoker.class, 0);
    private Class<P> producedType = (Class)TypeResolver.resolve(this.getClass(), CommandInvoker.class, 1);
    private final MetaData metaData = MetaData.getMetaData(this.getClass());
    private String[] args = null;
    private String line = null;
    @Option(name="-h", aliases={"--help"})
    private boolean help;

    protected BaseCommand() {
    }

    @Override
    public Class<P> getProducedType() {
        return this.producedType;
    }

    @Override
    public Class<C> getConsumedType() {
        return this.consumedType;
    }

    public final boolean getUnquoteArguments() {
        return this.unquoteArguments;
    }

    public final void setUnquoteArguments(boolean unquoteArguments) {
        this.unquoteArguments = unquoteArguments;
    }

    protected final String readLine(String msg) {
        return this.readLine(msg, true);
    }

    protected final String readLine(String msg, boolean echo) {
        if (this.context == null) {
            throw new IllegalStateException("No current context");
        }
        return this.context.readLine(msg, echo);
    }

    @Override
    protected final InvocationContext<?, ?> getContext() {
        return this.context;
    }

    @Override
    public final Map<String, String> complete(CommandContext context, String line) {
        return Collections.emptyMap();
    }

    @Override
    public String describe(String line, DescriptionMode mode) {
        Description description = this.getClass().getAnnotation(Description.class);
        switch (mode) {
            case DESCRIBE: {
                return description != null ? description.value() : null;
            }
            case USAGE: {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                if (description != null) {
                    pw.write(description.value());
                    pw.write("\n");
                }
                switch (this.metaData.descriptionFramework) {
                    default: {
                        System.out.println("Not only one description framework");
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        CmdLineParser parser = new CmdLineParser(this);
                        parser.printUsage(pw, null);
                        break;
                    }
                    case 2: {
                        throw new UnsupportedOperationException();
                    }
                }
                return sw.toString();
            }
        }
        return null;
    }

    @Override
    public final CommandInvoker<?, ?> createInvoker(String line) {
        List<String> chunks = Strings.chunks(line);
        this.args = chunks.toArray(new String[chunks.size()]);
        this.line = line;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(InvocationContext<C, P> context) throws ScriptException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.args == null) {
            throw new NullPointerException();
        }
        if (this.unquoteArguments) {
            String[] foo = new String[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                String arg = this.args[i];
                if (arg.charAt(0) == '\'') {
                    if (arg.charAt(arg.length() - 1) == '\'') {
                        arg = arg.substring(1, arg.length() - 1);
                    }
                } else if (arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
                    arg = arg.substring(1, arg.length() - 1);
                }
                foo[i] = arg;
            }
            this.args = foo;
        }
        switch (this.metaData.descriptionFramework) {
            default: {
                System.out.println("Not only one description framework");
            }
            case 0: {
                break;
            }
            case 1: {
                try {
                    CmdLineParser parser = new CmdLineParser(this);
                    parser.parseArgument(this.args);
                    break;
                }
                catch (CmdLineException e) {
                    throw new ScriptException(e.getMessage(), e);
                }
            }
        }
        if (this.help) {
            String usage = this.describe(this.line, DescriptionMode.USAGE);
            if (usage != null) {
                context.getWriter().println(usage);
            }
        } else {
            try {
                this.context = context;
                this.execute(context);
            }
            finally {
                this.context = null;
            }
        }
    }

    protected abstract void execute(InvocationContext<C, P> var1) throws ScriptException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetaData {
        private static final ConcurrentHashMap<String, MetaData> metaDataCache = new ConcurrentHashMap();
        private static final Pattern ARGS4J = Pattern.compile("^org\\.kohsuke\\.args4j\\.?$");
        private final int descriptionFramework;
        private final String fqn;
        private final int identityHashCode;

        static MetaData getMetaData(Class<?> clazz) {
            MetaData metaData = metaDataCache.get(clazz.getName());
            if (metaData == null || !metaData.isValid(clazz)) {
                metaData = new MetaData(clazz);
                metaDataCache.put(clazz.getName(), metaData);
            }
            return metaData;
        }

        private MetaData(Class<?> clazz) {
            this.descriptionFramework = this.findDescriptionFramework(clazz);
            this.fqn = clazz.getName();
            this.identityHashCode = System.identityHashCode(clazz);
        }

        private boolean isValid(Class<?> clazz) {
            return this.identityHashCode == System.identityHashCode(clazz) && this.fqn.equals(clazz.getName());
        }

        private int findDescriptionFramework(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            Class<?> superClazz = clazz.getSuperclass();
            int bs = superClazz != null ? this.findDescriptionFramework(superClazz) : 0;
            for (Field f : clazz.getDeclaredFields()) {
                for (Annotation annotation : f.getDeclaredAnnotations()) {
                    String packageName = annotation.annotationType().getPackage().getName();
                    if (!ARGS4J.matcher(packageName).matches()) continue;
                    bs |= 1;
                }
            }
            return bs;
        }
    }
}

