/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginManager;
import org.crsh.plugin.PropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginLifeCycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private PluginManager<CRaSHPlugin> manager;
    private PluginContext context;

    public PluginContext getContext() {
        return this.context;
    }

    public final void start(PluginContext context) {
        this.context = context;
        for (PropertyDescriptor<?> desc : PropertyDescriptor.ALL.values()) {
            String key = "crash." + desc.name;
            String value = System.getProperty(key);
            if (value == null) continue;
            try {
                this.log.info("Configuring property " + desc.name + " from system properties");
                context.setProperty(desc, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.manager = new PluginManager<CRaSHPlugin>(context, CRaSHPlugin.class);
        context.start();
        this.manager.getPlugins();
    }

    public final void stop() {
        this.manager.shutdown();
        this.context.stop();
    }
}

