/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.crsh.command.InvocationContext;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.impl.CommandContextImpl;
import org.crsh.shell.io.ShellPrinter;
import org.crsh.util.LineFeedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvocationContextImpl<C, P>
extends CommandContextImpl
implements InvocationContext<C, P> {
    private final ShellProcessContext processContext;
    private ShellPrinter writer;
    private StringWriter buffer;
    private List<P> products;
    private Iterable<C> consumedItems;

    InvocationContextImpl(ShellProcessContext processContext, Iterable<C> consumedItems, Map<String, Object> attributes) {
        super(attributes);
        this.processContext = processContext;
        this.writer = null;
        this.buffer = null;
        this.consumedItems = consumedItems;
        this.products = Collections.emptyList();
    }

    @Override
    public int getWidth() {
        return this.processContext.getWidth();
    }

    public List<P> getProducedItems() {
        return this.products;
    }

    public StringWriter getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isPiped() {
        return this.consumedItems != null;
    }

    @Override
    public Iterable<C> consume() {
        if (this.consumedItems == null) {
            throw new IllegalStateException("Cannot consume as no pipe operation is involved");
        }
        return this.consumedItems;
    }

    @Override
    public void produce(P product) {
        if (this.products.isEmpty()) {
            this.products = new LinkedList<P>();
        }
        this.products.add(product);
    }

    @Override
    public ShellPrinter getWriter() {
        if (this.writer == null) {
            this.buffer = new StringWriter();
            this.writer = new ShellPrinter(new LineFeedWriter(this.buffer, "\r\n"));
        }
        return this.writer;
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return this.processContext.readLine(msg, echo);
    }
}

