/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.binding.MethodArgumentBinding;
import org.crsh.cmdline.matcher.ArgumentMatch;
import org.crsh.cmdline.matcher.ClassMatch;
import org.crsh.cmdline.matcher.CmdInvocationException;
import org.crsh.cmdline.matcher.CmdLineException;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.ParameterMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMatch<T>
extends CommandMatch<T, MethodDescriptor<T>, MethodArgumentBinding> {
    private final MethodDescriptor<T> descriptor;
    private final ClassMatch<T> owner;
    private final boolean implicit;

    public MethodMatch(ClassMatch<T> owner, MethodDescriptor<T> descriptor, boolean implicit, List<OptionMatch<MethodArgumentBinding>> optionMatches, List<ArgumentMatch<MethodArgumentBinding>> argumentMatches, String rest) {
        super(optionMatches, argumentMatches, rest);
        this.owner = owner;
        this.descriptor = descriptor;
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public MethodDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    public ClassMatch<T> getOwner() {
        return this.owner;
    }

    @Override
    public void printMan(Appendable writer) throws IOException {
        if (this.implicit) {
            this.getOwner().printMan(writer);
        } else {
            this.descriptor.printMan(writer);
        }
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        if (this.implicit) {
            this.getOwner().printUsage(writer);
        } else {
            this.descriptor.printUsage(writer);
        }
    }

    @Override
    public Set<ParameterDescriptor<?>> getParameters() {
        HashSet unused = new HashSet();
        unused.addAll(this.descriptor.getArguments());
        unused.addAll(this.descriptor.getOptions());
        unused.addAll(this.owner.getDescriptor().getOptions());
        return unused;
    }

    @Override
    public List<ParameterMatch<?, ?>> getParameterMatches() {
        ArrayList matches = new ArrayList();
        matches.addAll(this.getOptionMatches());
        matches.addAll(this.getArgumentMatches());
        matches.addAll(this.owner.getOptionMatches());
        return matches;
    }

    @Override
    protected Object doInvoke(InvocationContext context, T command, Map<ParameterDescriptor<?>, Object> values) throws CmdLineException {
        CommandDescriptor descriptor = this.getDescriptor();
        Method m = ((MethodDescriptor)descriptor).getMethod();
        Class<?>[] parameterTypes = m.getParameterTypes();
        Object[] mArgs = new Object[parameterTypes.length];
        for (int i = 0; i < mArgs.length; ++i) {
            ParameterDescriptor<MethodArgumentBinding> parameter = ((MethodDescriptor)descriptor).getParameter(i);
            Class<?> parameterType = parameterTypes[i];
            Object v = parameter == null ? context.getAttribute(parameterType) : values.get(parameter);
            if (v == null && (parameterType.isPrimitive() || parameter.isRequired())) {
                throw new CmdSyntaxException("Non satisfied parameter " + parameter);
            }
            mArgs[i] = v;
        }
        this.owner.doInvoke(context, command, values);
        try {
            return m.invoke(command, mArgs);
        }
        catch (Exception e) {
            throw new CmdInvocationException(e.getMessage(), e);
        }
    }
}

