/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.plugin.Property;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginContext {
    private static final Pattern p = Pattern.compile("(.+)\\.groovy");
    private static final Logger log = LoggerFactory.getLogger(PluginContext.class);
    private final ClassLoader loader;
    private final String version;
    private ScheduledExecutorService executor;
    private volatile List<File> dirs;
    private final Map<PropertyDescriptor<?>, Property<?>> properties;
    private final FS vfs;
    private boolean started;

    public PluginContext(FS fs, ClassLoader loader) throws NullPointerException {
        if (fs == null) {
            throw new NullPointerException();
        }
        if (loader == null) {
            throw new NullPointerException();
        }
        String version = null;
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.crsh/crsh.shell.core/pom.properties");
            if (in != null) {
                props.load(in);
                version = props.getProperty("version");
            }
        }
        catch (Exception e) {
            log.error("Could not load maven properties", e);
        }
        if (version == null) {
            log.warn("No version found will use unknown value instead");
            version = "unknown";
        }
        this.loader = loader;
        this.version = version;
        this.dirs = Collections.emptyList();
        this.vfs = fs;
        this.properties = new HashMap();
        this.started = false;
    }

    public final String getVersion() {
        return this.version;
    }

    public final <T> T getProperty(PropertyDescriptor<T> desc) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException();
        }
        Property<?> property = this.properties.get(desc);
        return (T)(property != null ? property.getValue() : desc.defaultValue);
    }

    public final <T> void setProperty(PropertyDescriptor<T> desc, T value) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.debug("Removing property " + desc.name);
            this.properties.remove(desc);
        } else {
            Property<T> property = new Property<T>(desc, value);
            log.debug("Setting property " + desc.name + " to value " + property.getValue());
            this.properties.put(desc, property);
        }
    }

    public final <T> void setProperty(PropertyDescriptor<T> desc, String value) throws NullPointerException, IllegalArgumentException {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.debug("Removing property " + desc.name);
            this.properties.remove(desc);
        } else {
            Property<T> property = desc.toProperty(value);
            log.debug("Setting property " + desc.name + " to value " + property.getValue());
            this.properties.put(desc, property);
        }
    }

    public final Resource loadResource(String resourceId, ResourceKind resourceKind) {
        Resource res = null;
        try {
            switch (resourceKind) {
                case LIFECYCLE: {
                    if (!"login".equals(resourceId) && !"logout".equals(resourceId)) break;
                    StringBuilder sb = new StringBuilder();
                    long timestamp = Long.MIN_VALUE;
                    for (File path : this.dirs) {
                        Resource sub;
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null || (sub = f.getResource()) == null) continue;
                        sb.append(sub.getContent() + "\n");
                        timestamp = Math.max(timestamp, sub.getTimestamp());
                    }
                    return new Resource(sb.toString(), timestamp);
                }
                case SCRIPT: {
                    for (File path : this.dirs) {
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null) continue;
                        return f.getResource();
                    }
                    break;
                }
                case CONFIG: {
                    if (!"telnet.properties".equals(resourceId)) break;
                    File telnet = this.vfs.get(Path.get("/telnet/telnet.properties"));
                    if (telnet != null && telnet != null) {
                        return telnet.getResource();
                    }
                    break;
                }
                case KEY: {
                    File key;
                    if (!"hostkey.pem".equals(resourceId) || (key = this.vfs.get(Path.get("/ssh/hostkey.pem"))) == null) break;
                    return key.getResource();
                }
            }
        }
        catch (IOException e) {
            log.warn("Could not obtain resource " + resourceId, e);
        }
        return res;
    }

    public final List<String> listResourceId(ResourceKind kind) {
        switch (kind) {
            case SCRIPT: {
                TreeSet<String> all = new TreeSet<String>();
                try {
                    for (File path : this.dirs) {
                        for (File file : path.children()) {
                            String name = file.getName();
                            Matcher matcher = p.matcher(name);
                            if (!matcher.matches()) continue;
                            all.add(matcher.group(1));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                all.remove("login");
                all.remove("logout");
                return new ArrayList<String>(all);
            }
        }
        return Collections.emptyList();
    }

    public final ClassLoader getLoader() {
        return this.loader;
    }

    public final void refresh() {
        try {
            File commands = this.vfs.get(Path.get("/commands/"));
            ArrayList<File> newDirs = new ArrayList<File>();
            newDirs.add(commands);
            for (File path : commands.children()) {
                if (!path.isDir()) continue;
                newDirs.add(path);
            }
            this.dirs = newDirs;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final synchronized void start() {
        Integer refreshRate = this.getProperty(PropertyDescriptor.VFS_REFRESH_PERIOD);
        TimeUnit timeUnit = this.getProperty(PropertyDescriptor.VFS_REFRESH_UNIT);
        if (!this.started) {
            if (refreshRate != null && refreshRate > 0) {
                TimeUnit tu = timeUnit != null ? timeUnit : TimeUnit.SECONDS;
                this.executor = new ScheduledThreadPoolExecutor(1);
                this.executor.scheduleWithFixedDelay(new Runnable(){
                    int count = 0;

                    public void run() {
                        PluginContext.this.refresh();
                    }
                }, 0L, refreshRate.intValue(), tu);
            }
            this.started = true;
        } else {
            log.warn("Attempt to double start");
        }
    }

    public final synchronized void stop() {
        if (this.started) {
            ScheduledExecutorService tmp = this.executor;
            this.executor = null;
            tmp.shutdown();
        } else {
            log.warn("Attempt to stop when stopped");
        }
    }
}

