/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.display;

import java.io.PrintWriter;
import org.crsh.display.DisplayWriter;

public abstract class DisplayContext {
    private DisplayWriter writer;

    public final void write(char[] cbuf, int off, int len) {
        int previous = off;
        int to = off + len;
        for (int i = off; i < to; ++i) {
            if (cbuf[i] != '\n') continue;
            if (i > previous) {
                this.print(cbuf, previous, i - previous);
            }
            this.println();
            previous = i + 1;
            ++i;
        }
        if (to != previous) {
            this.print(cbuf, previous, to - previous);
        }
    }

    public PrintWriter printer() {
        if (this.writer == null) {
            this.writer = new DisplayWriter(this);
        }
        return this.writer.getPrinter();
    }

    protected abstract void print(char[] var1, int var2, int var3);

    protected abstract void println();
}

