/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.vfs.FS;
import org.crsh.vfs.spi.servlet.ServletContextDriver;

public class WebPluginLifeCycle
extends PluginLifeCycle
implements ServletContextListener {
    private static final Object lock = new Object();
    private static final Map<String, PluginContext> contextMap = new HashMap<String, PluginContext>();
    private boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginContext getPluginContext(ServletContext sc) throws NullPointerException {
        String contextPath = sc.getContextPath();
        Object object = lock;
        synchronized (object) {
            return contextMap.get(contextPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        String contextPath = sc.getContextPath();
        Object object = lock;
        synchronized (object) {
            if (!contextMap.containsKey(contextPath)) {
                FS fs = new FS().mount(new ServletContextDriver(sc), "/WEB-INF/crash/");
                PluginContext context = new PluginContext(fs, Thread.currentThread().getContextClassLoader());
                contextMap.put(contextPath, context);
                this.registered = true;
                Enumeration names = sc.getInitParameterNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (!name.startsWith("crash.")) continue;
                    String value = sc.getInitParameter(name).trim();
                    String key = name.substring("crash.".length());
                    PropertyDescriptor<?> desc = PropertyDescriptor.ALL.get(key);
                    context.setProperty(desc, value);
                }
                this.start(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        if (this.registered) {
            ServletContext sc = sce.getServletContext();
            String contextPath = sc.getContextPath();
            Object object = lock;
            synchronized (object) {
                contextMap.remove(contextPath);
                this.registered = false;
                this.stop();
            }
        }
    }
}

